/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler.render;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.feedback.FeedbackCollector;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.render.PageRenderer;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPageRenderer
extends PageRenderer {
    private static final Logger logger = LoggerFactory.getLogger(WebPageRenderer.class);

    public WebPageRenderer(RenderPageRequestHandler renderPageRequestHandler) {
        super(renderPageRequestHandler);
    }

    protected boolean isAjax(RequestCycle requestCycle) {
        boolean isAjax = false;
        Request request = requestCycle.getRequest();
        if (request instanceof WebRequest) {
            WebRequest webRequest = (WebRequest)request;
            isAjax = webRequest.isAjax();
        }
        return isAjax;
    }

    protected void storeBufferedResponse(Url url, BufferedWebResponse response) {
        if (this.isSessionTemporary()) {
            Session.get().bind();
        }
        WebApplication.get().storeBufferedResponse(this.getSessionId(), url, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedWebResponse renderPage(Url targetUrl, RequestCycle requestCycle) {
        IRequestablePage requestablePage = this.getPage();
        IRequestHandler scheduled = requestCycle.getRequestHandlerScheduledAfterCurrent();
        if (scheduled != null) {
            return null;
        }
        WebResponse originalResponse = (WebResponse)requestCycle.getResponse();
        BufferedWebResponse response = new BufferedWebResponse(originalResponse);
        Url originalBaseUrl = requestCycle.getUrlRenderer().setBaseUrl(targetUrl);
        try {
            requestCycle.setResponse((Response)response);
            requestablePage.renderPage();
            if (requestCycle.getRequestHandlerScheduledAfterCurrent() != null) {
                originalResponse.reset();
                response.writeMetaData(originalResponse);
                BufferedWebResponse bufferedWebResponse = null;
                return bufferedWebResponse;
            }
            BufferedWebResponse bufferedWebResponse = response;
            return bufferedWebResponse;
        }
        finally {
            requestCycle.setResponse((Response)originalResponse);
            requestCycle.getUrlRenderer().setBaseUrl(originalBaseUrl);
        }
    }

    protected void redirectTo(Url url, RequestCycle requestCycle) {
        this.bindSessionIfNeeded();
        WebResponse response = (WebResponse)requestCycle.getResponse();
        String relativeUrl = requestCycle.getUrlRenderer().renderUrl(url);
        response.sendRedirect(relativeUrl);
    }

    private void bindSessionIfNeeded() {
        FeedbackCollector collector = new FeedbackCollector();
        List<FeedbackMessage> feedbackMessages = collector.collect();
        if (feedbackMessages.size() > 0) {
            Session.get().bind();
        }
    }

    @Override
    public void respond(RequestCycle requestCycle) {
        Url targetUrl;
        Url currentUrl = requestCycle.getUrlRenderer().getBaseUrl();
        if (this.shouldRenderPageAndWriteResponse(requestCycle, currentUrl, targetUrl = requestCycle.mapUrlFor(this.getRenderPageRequestHandler()))) {
            BufferedWebResponse response = this.renderPage(currentUrl, requestCycle);
            if (response != null) {
                response.writeTo((WebResponse)requestCycle.getResponse());
            }
        } else if (this.shouldRedirectToTargetUrl(requestCycle, currentUrl, targetUrl)) {
            this.redirectTo(targetUrl, requestCycle);
        } else {
            if (!this.isRedirectToBuffer() && logger.isDebugEnabled()) {
                String details = String.format("redirect strategy: '%s', isAjax: '%s', redirect policy: '%s', current url: '%s', target url: '%s', is new: '%s', is stateless: '%s', is temporary: '%s'", new Object[]{Application.get().getRequestCycleSettings().getRenderStrategy(), this.isAjax(requestCycle), this.getRedirectPolicy(), currentUrl, targetUrl, this.isNewPageInstance(), this.isPageStateless(), this.isSessionTemporary()});
                logger.debug("Falling back to Redirect_To_Buffer render strategy because none of the conditions matched. Details: " + details);
            }
            this.getPage();
            Url beforeRenderUrl = requestCycle.mapUrlFor(this.getRenderPageRequestHandler());
            BufferedWebResponse response = this.renderPage(beforeRenderUrl, requestCycle);
            if (response == null) {
                return;
            }
            Url afterRenderUrl = requestCycle.mapUrlFor(this.getRenderPageRequestHandler());
            if (!beforeRenderUrl.getSegments().equals(afterRenderUrl.getSegments())) {
                response = this.renderPage(afterRenderUrl, requestCycle);
            }
            if (currentUrl.equals((Object)afterRenderUrl)) {
                response.writeTo((WebResponse)requestCycle.getResponse());
            } else if (this.isPageStateless() && !this.enableRedirectForStatelessPage()) {
                response.writeTo((WebResponse)requestCycle.getResponse());
            } else {
                this.storeBufferedResponse(afterRenderUrl, response);
                this.redirectTo(afterRenderUrl, requestCycle);
            }
        }
    }

    protected boolean isPageStateless() {
        return this.getPage().isPageStateless();
    }

    protected boolean isNewPageInstance() {
        return !this.getPageProvider().hasPageInstance();
    }

    protected boolean shouldPreserveClientUrl(RequestCycle requestCycle) {
        return ((WebRequest)requestCycle.getRequest()).shouldPreserveClientUrl();
    }

    protected boolean shouldRedirectToTargetUrl(RequestCycle cycle, Url currentUrl, Url targetUrl) {
        return WebPageRenderer.alwaysRedirect(this.getRedirectPolicy()) || this.isRedirectToRender() || this.isAjax(cycle) && targetUrl.equals((Object)currentUrl) || !targetUrl.equals((Object)currentUrl) && (this.isNewPageInstance() || this.isSessionTemporary() && this.isPageStateless());
    }

    protected boolean shouldRenderPageAndWriteResponse(RequestCycle cycle, Url currentUrl, Url targetUrl) {
        if (this.isAjax(cycle)) {
            return false;
        }
        return this.compatibleProtocols(currentUrl.getProtocol(), targetUrl.getProtocol()) && (WebPageRenderer.neverRedirect(this.getRedirectPolicy()) || this.isOnePassRender() && WebPageRenderer.notForcedRedirect(this.getRedirectPolicy()) || targetUrl.equals((Object)currentUrl) && !this.isNewPageInstance() && !this.isPageStateless() || targetUrl.equals((Object)currentUrl) && this.isRedirectToRender() || this.shouldPreserveClientUrl(cycle) && WebPageRenderer.notForcedRedirect(this.getRedirectPolicy()));
    }

    private static boolean neverRedirect(RenderPageRequestHandler.RedirectPolicy redirectPolicy) {
        return redirectPolicy == RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT;
    }

    private static boolean alwaysRedirect(RenderPageRequestHandler.RedirectPolicy redirectPolicy) {
        return redirectPolicy == RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT;
    }

    private static boolean notForcedRedirect(RenderPageRequestHandler.RedirectPolicy redirectPolicy) {
        return !WebPageRenderer.alwaysRedirect(redirectPolicy);
    }

    protected boolean compatibleProtocols(String p1, String p2) {
        if (p1 != null && p2 != null) {
            return Objects.equal((Object)p1, (Object)p2);
        }
        return true;
    }
}

