/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import org.apache.commons.jexl3.internal.introspection.Introspector;
import org.apache.commons.jexl3.internal.introspection.MethodKey;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;

public final class IndexedType
implements JexlPropertyGet {
    private final String container;
    private final Class<?> clazz;
    private final Method[] getters;
    private final Method[] setters;

    public static JexlPropertyGet discover(Introspector is, Object object, String name) {
        if (object != null && name != null) {
            String base = name.substring(0, 1).toUpperCase() + name.substring(1);
            String container = name;
            Class<?> clazz = object.getClass();
            Method[] getters = is.getMethods(object.getClass(), "get" + base);
            Method[] setters = is.getMethods(object.getClass(), "set" + base);
            if (getters != null) {
                return new IndexedType(container, clazz, getters, setters);
            }
        }
        return null;
    }

    private IndexedType(String name, Class<?> c, Method[] gets, Method[] sets) {
        this.container = name;
        this.clazz = c;
        this.getters = gets;
        this.setters = sets;
    }

    @Override
    public Object invoke(Object obj) throws Exception {
        if (obj != null && this.clazz.equals(obj.getClass())) {
            return new IndexedContainer(this, obj);
        }
        throw new IntrospectionException("property resolution error");
    }

    @Override
    public Object tryInvoke(Object obj, Object key) {
        if (obj != null && key != null && this.clazz.equals(obj.getClass()) && this.container.equals(key.toString())) {
            return new IndexedContainer(this, obj);
        }
        return Uberspect.TRY_FAILED;
    }

    @Override
    public boolean tryFailed(Object rval) {
        return rval == Uberspect.TRY_FAILED;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    private Object invokeGet(Object object, Object key) throws Exception {
        if (this.getters != null) {
            Object[] args = new Object[]{key};
            Method jm = this.getters.length == 1 ? this.getters[0] : new MethodKey(this.getters[0].getName(), args).getMostSpecificMethod(this.getters);
            if (jm != null) {
                return jm.invoke(object, args);
            }
        }
        throw new IntrospectionException("property get error: " + object.getClass().toString() + "@" + key.toString());
    }

    private Object invokeSet(Object object, Object key, Object value) throws Exception {
        if (this.setters != null) {
            Object[] args = new Object[]{key, value};
            Method jm = this.setters.length == 1 ? this.setters[0] : new MethodKey(this.setters[0].getName(), args).getMostSpecificMethod(this.setters);
            if (jm != null) {
                return jm.invoke(object, args);
            }
        }
        throw new IntrospectionException("property set error: " + object.getClass().toString() + "@" + key.toString());
    }

    public static final class IndexedContainer {
        private final Object object;
        private final IndexedType type;

        private IndexedContainer(IndexedType theType, Object theObject) {
            this.type = theType;
            this.object = theObject;
        }

        public Object get(Object key) throws Exception {
            return this.type.invokeGet(this.object, key);
        }

        public Object set(Object key, Object value) throws Exception {
            return this.type.invokeSet(this.object, key, value);
        }
    }
}

