/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal;

import jakarta.xml.bind.annotation.XmlTransient;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.quality.DefaultAbsoluteExternalPositionalAccuracy;
import org.apache.sis.metadata.iso.quality.DefaultConformanceResult;
import org.apache.sis.metadata.iso.quality.DefaultEvaluationMethod;
import org.apache.sis.metadata.iso.quality.DefaultMeasureReference;
import org.apache.sis.metadata.iso.quality.DefaultQuantitativeResult;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.iso.DefaultRecord;
import org.apache.sis.util.iso.DefaultRecordType;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.quality.EvaluationMethodType;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.metadata.quality.QuantitativeResult;
import org.opengis.metadata.quality.Result;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

@XmlTransient
public final class PositionalAccuracyConstant
extends DefaultAbsoluteExternalPositionalAccuracy {
    private static final long serialVersionUID = -2554090935254116470L;
    public static final double UNKNOWN_ACCURACY = 3000.0;
    public static final double DATUM_SHIFT_ACCURACY = 25.0;
    public static final double INDIRECT_SHIFT_ACCURACY = 100.0;
    public static final PositionalAccuracy DATUM_SHIFT_APPLIED;
    public static final PositionalAccuracy DATUM_SHIFT_OMITTED;
    public static final PositionalAccuracy INDIRECT_SHIFT_APPLIED;
    private static final DefaultMeasureReference ENSEMBLE_REFERENCE;
    private static final DefaultMeasureReference TRANSFORMATION_REFERENCE;
    private static final DefaultEvaluationMethod EVALUATION_METHOD;
    private static final WeakValueHashMap<Double, PositionalAccuracy> CACHE;

    private PositionalAccuracyConstant(DefaultMeasureReference reference, DefaultEvaluationMethod method, DefaultConformanceResult result, Double accuracy) {
        this.setMeasureReference(reference);
        this.setEvaluationMethod(method);
        ArrayList<Object> results = new ArrayList<Object>(2);
        if (result != null) {
            results.add(result);
        }
        if (accuracy != null) {
            DefaultRecordType type = DefaultRecordType.SINGLE_REAL;
            DefaultRecord record = new DefaultRecord((RecordType)type);
            record.setAll(new Object[]{accuracy});
            DefaultQuantitativeResult r = new DefaultQuantitativeResult();
            r.setValues(List.of(record));
            r.setValueUnit(Units.METRE);
            r.setValueType((RecordType)type);
            results.add(r);
        }
        this.setResults(results);
        this.transitionTo(ModifiableMetadata.State.FINAL);
    }

    public static PositionalAccuracy transformation(double accuracy) {
        if (accuracy >= 0.0) {
            return (PositionalAccuracy)CACHE.computeIfAbsent((Object)Math.abs(accuracy), key -> new PositionalAccuracyConstant(TRANSFORMATION_REFERENCE, EVALUATION_METHOD, null, (Double)key));
        }
        return null;
    }

    public static PositionalAccuracy ensemble(double accuracy) {
        if (accuracy >= 0.0) {
            return (PositionalAccuracy)CACHE.computeIfAbsent((Object)(-Math.abs(accuracy)), key -> new PositionalAccuracyConstant(ENSEMBLE_REFERENCE, EVALUATION_METHOD, null, -key.doubleValue()));
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.equals(DATUM_SHIFT_APPLIED)) {
            return DATUM_SHIFT_APPLIED;
        }
        if (this.equals(DATUM_SHIFT_OMITTED)) {
            return DATUM_SHIFT_OMITTED;
        }
        if (this.equals(INDIRECT_SHIFT_APPLIED)) {
            return INDIRECT_SHIFT_APPLIED;
        }
        return this;
    }

    public static double getLinearAccuracy(Iterable<PositionalAccuracy> accuracies) {
        double accuracy = Double.NaN;
        for (PositionalAccuracy metadata : accuracies) {
            for (Result result : metadata.getResults()) {
                Unit unit;
                QuantitativeResult quantity;
                Collection records;
                if (!(result instanceof QuantitativeResult) || (records = (quantity = (QuantitativeResult)result).getValues()) == null || !Units.isLinear((Unit)(unit = quantity.getValueUnit()))) continue;
                Unit unitOfLength = unit.asType(Length.class);
                for (Record record : records) {
                    for (Object value : record.getAttributes().values()) {
                        if (!(value instanceof Number)) continue;
                        double v = ((Number)value).doubleValue();
                        v = unitOfLength.getConverterTo(Units.METRE).convert(v);
                        if (!(v >= 0.0) || v <= accuracy) continue;
                        accuracy = v;
                    }
                }
            }
        }
        return accuracy;
    }

    public static double getLinearAccuracy(CoordinateOperation operation) {
        double accuracy = PositionalAccuracyConstant.getLinearAccuracy(operation.getCoordinateOperationAccuracy());
        if (Double.isNaN(accuracy)) {
            if (operation instanceof Conversion) {
                return 0.0;
            }
            if (operation instanceof ConcatenatedOperation) {
                for (CoordinateOperation op : ((ConcatenatedOperation)operation).getOperations()) {
                    double candidate = Math.abs(PositionalAccuracyConstant.getLinearAccuracy(op));
                    if (Double.isNaN(candidate)) continue;
                    if (Double.isNaN(accuracy)) {
                        accuracy = candidate;
                        continue;
                    }
                    accuracy += candidate;
                }
            }
        }
        return accuracy;
    }

    static {
        ENSEMBLE_REFERENCE = new DefaultMeasureReference((CharSequence)Vocabulary.formatInternational((short)278));
        TRANSFORMATION_REFERENCE = new DefaultMeasureReference((CharSequence)Vocabulary.formatInternational((short)200));
        EVALUATION_METHOD = new DefaultEvaluationMethod(EvaluationMethodType.DIRECT_EXTERNAL, (CharSequence)Resources.formatInternational((short)105));
        ENSEMBLE_REFERENCE.transitionTo(ModifiableMetadata.State.FINAL);
        TRANSFORMATION_REFERENCE.transitionTo(ModifiableMetadata.State.FINAL);
        EVALUATION_METHOD.transitionTo(ModifiableMetadata.State.FINAL);
        InternationalString desc = Resources.formatInternational((short)11);
        DefaultEvaluationMethod method = new DefaultEvaluationMethod(EvaluationMethodType.DIRECT_INTERNAL, (CharSequence)desc);
        DefaultConformanceResult pass = new DefaultConformanceResult(Citations.SIS, (CharSequence)desc, true);
        DefaultConformanceResult fail = new DefaultConformanceResult(Citations.SIS, (CharSequence)desc, false);
        DATUM_SHIFT_APPLIED = new PositionalAccuracyConstant(TRANSFORMATION_REFERENCE, method, pass, 25.0);
        DATUM_SHIFT_OMITTED = new PositionalAccuracyConstant(TRANSFORMATION_REFERENCE, method, fail, 3000.0);
        INDIRECT_SHIFT_APPLIED = new PositionalAccuracyConstant(TRANSFORMATION_REFERENCE, method, pass, 100.0);
        CACHE = new WeakValueHashMap(Double.class);
    }
}

