/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.StoredTree;
import org.apache.sis.io.wkt.UnparsableObjectException;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.opengis.referencing.cs.CoordinateSystem;

final class Element {
    private static final int NUMERIC = 1;
    private static final int TEMPORAL = 2;
    private static final String[] TIME_KEYWORDS = new String[]{"TimeOrigin", "TimeExtent"};
    final int offset;
    private byte keywordIndex;
    public final String keyword;
    private final boolean isEnumeration;
    final boolean isFragment;
    boolean isRoot;
    private final List<Object> children;
    private final Locale errorLocale;

    Element(Element singleton) {
        this.keyword = "<root>";
        this.offset = singleton.offset;
        this.errorLocale = singleton.errorLocale;
        this.isEnumeration = false;
        this.isFragment = false;
        this.children = new LinkedList<Object>();
        this.children.add(singleton);
        singleton.isRoot = true;
    }

    Element(String keyword, LinkedList<Object> children, int offset, Locale errorLocale) {
        this.keyword = keyword;
        this.isEnumeration = children == null;
        this.children = this.isEnumeration ? List.of() : children;
        this.isFragment = offset < 0;
        this.offset = this.isFragment ? ~offset : offset;
        this.errorLocale = errorLocale;
    }

    Element(AbstractParser parser, String text, ParsePosition position) throws ParseException {
        int openingBracket;
        int closingBracket;
        int c;
        this.isFragment = false;
        this.errorLocale = parser.errorLocale;
        this.offset = position.getIndex();
        int length = text.length();
        int lower = CharSequences.skipLeadingWhitespaces((CharSequence)text, (int)this.offset, (int)length);
        int n = c = lower < length ? text.codePointAt(lower) : 0;
        if (!Character.isUnicodeIdentifierStart(c)) {
            this.keyword = text;
            position.setErrorIndex(lower);
            throw this.unparsableString(text, position);
        }
        int upper = lower;
        while ((upper += Character.charCount(c)) < length && Character.isUnicodeIdentifierPart(c = text.codePointAt(upper))) {
        }
        this.keyword = text.substring(lower, upper);
        lower = CharSequences.skipLeadingWhitespaces((CharSequence)text, (int)upper, (int)length);
        int valueType = 0;
        if (lower >= length || (closingBracket = parser.symbols.matchingBracket(openingBracket = text.codePointAt(lower))) < 0) {
            position.setIndex(lower);
            this.children = List.of();
            this.isEnumeration = true;
            return;
        }
        lower = CharSequences.skipLeadingWhitespaces((CharSequence)text, (int)(lower + Character.charCount(openingBracket)), (int)length);
        this.children = new LinkedList<Object>();
        this.isEnumeration = false;
        String separator = parser.symbols.trimmedSeparator();
        while (lower < length) {
            int firstChar = text.codePointAt(lower);
            if (firstChar == 36) {
                int upper2;
                String id;
                StoredTree fragment;
                if ((fragment = parser.fragments.get(id = text.substring(lower--, upper2 = AbstractParser.endOfFragmentName(text, ++lower)))) == null) {
                    position.setIndex(this.offset);
                    position.setErrorIndex(lower);
                    throw new UnparsableObjectException(this.errorLocale, 121, new Object[]{id}, lower);
                }
                fragment.toElements(parser, this.children, ~lower);
                lower = upper2;
            } else if (Character.isUnicodeIdentifierStart(firstChar)) {
                if (lower != (lower = Element.regionMatches(text, lower, "true"))) {
                    this.children.add(Boolean.TRUE);
                } else if (lower != (lower = Element.regionMatches(text, lower, "false"))) {
                    this.children.add(Boolean.FALSE);
                } else {
                    position.setIndex(lower);
                    this.children.add(new Element(parser, text, position));
                    lower = position.getIndex();
                }
            } else {
                Object value;
                int closingQuote = parser.symbols.matchingQuote(firstChar);
                if (closingQuote >= 0) {
                    int upper3;
                    int n2 = Character.charCount(closingQuote);
                    lower += Character.charCount(firstChar) - n2;
                    CharSequence content = null;
                    do {
                        if ((upper3 = text.indexOf(closingQuote, lower += n2)) < lower) {
                            throw this.missingCharacter(closingQuote, lower, position);
                        }
                        if (content == null) {
                            content = text.substring(lower, upper3);
                            continue;
                        }
                        if (content instanceof String) {
                            content = new StringBuilder((String)content);
                        }
                        ((StringBuilder)content).appendCodePoint(closingQuote).append(text, lower, upper3);
                    } while ((lower = upper3 + n2) < text.length() && text.codePointAt(lower) == closingQuote);
                    value = CharSequences.trimWhitespaces((CharSequence)content).toString();
                } else {
                    position.setIndex(lower);
                    if (valueType == 0) {
                        valueType = ArraysExt.containsIgnoreCase((String[])TIME_KEYWORDS, (String)this.keyword) ? 2 : 1;
                    }
                    switch (valueType) {
                        case 2: {
                            value = TemporalDate.toTemporal((Date)parser.parseDate(text, position));
                            break;
                        }
                        case 1: {
                            value = parser.parseNumber(text, position);
                            break;
                        }
                        default: {
                            throw new AssertionError(valueType);
                        }
                    }
                    if (value == null) {
                        throw this.unparsableString(text, position);
                    }
                    lower = position.getIndex();
                }
                this.children.add(value);
            }
            lower = CharSequences.skipLeadingWhitespaces((CharSequence)text, (int)lower, (int)length);
            if (text.startsWith(separator, lower)) {
                lower = CharSequences.skipLeadingWhitespaces((CharSequence)text, (int)(lower + separator.length()), (int)length);
                continue;
            }
            if (lower >= length) break;
            int c2 = text.codePointAt(lower);
            if (c2 == closingBracket) {
                position.setIndex(lower + Character.charCount(c2));
                return;
            }
            position.setErrorIndex(lower);
            throw this.unparsableString(text, position);
        }
        throw this.missingCharacter(closingBracket, lower, position);
    }

    private static int regionMatches(String text, int index, String word) {
        int end;
        if (text.regionMatches(true, index, word, 0, word.length()) && ((end = index + word.length()) >= text.length() || !Character.isUnicodeIdentifierPart(text.codePointAt(end)))) {
            return end;
        }
        return index;
    }

    final ParseException parseFailed(Exception cause) {
        Object message = Resources.forLocale(this.errorLocale).getString((short)101, this.keyword);
        message = (String)message + " " + Exceptions.getLocalizedMessage((Throwable)cause, (Locale)this.errorLocale);
        return new UnparsableObjectException((String)message, this.offset).initCause(cause);
    }

    private ParseException unparsableString(String text, ParsePosition position) {
        CharSequence[] arguments;
        short errorKey;
        int length;
        int errorIndex = Math.max(this.offset, position.getErrorIndex());
        if (errorIndex >= (length = text.length())) {
            errorKey = 169;
            arguments = new String[]{this.keyword};
        } else {
            errorKey = 188;
            arguments = new CharSequence[]{this.keyword, CharSequences.token((CharSequence)text, (int)errorIndex)};
        }
        position.setIndex(this.offset);
        return new UnparsableObjectException(this.errorLocale, errorKey, arguments, errorIndex);
    }

    private ParseException missingCharacter(int c, int errorIndex, ParsePosition position) {
        position.setIndex(this.offset);
        position.setErrorIndex(errorIndex);
        StringBuilder buffer = new StringBuilder(2).appendCodePoint(c);
        return new UnparsableObjectException(this.errorLocale, 105, new CharSequence[]{this.keyword, buffer}, errorIndex);
    }

    final ParseException missingComponent(String key) {
        return new UnparsableObjectException(this.errorLocale, 106, new String[]{this.keyword, key}, this.offsetAfterKeyword());
    }

    final ParseException missingOrUnknownComponent(String expected) {
        Object[] args;
        short res;
        String name = null;
        for (Object child : this.children) {
            if (child instanceof Element && (name = ((Element)child).keyword) != null) break;
        }
        if (name != null) {
            res = 180;
            args = new String[]{name};
        } else {
            res = 106;
            args = new String[]{this.keyword, expected};
        }
        return new UnparsableObjectException(this.errorLocale, res, args, this.offset);
    }

    final ParseException illegalCS(CoordinateSystem cs) {
        String value;
        short key;
        if (cs == null) {
            key = 141;
            value = "coordinateSystem";
        } else {
            key = 66;
            value = cs.getName().getCode();
        }
        return new UnparsableObjectException(this.errorLocale, key, new String[]{value}, this.offset);
    }

    private int offsetAfterKeyword() {
        if (this.isFragment) {
            return this.offset;
        }
        return this.offset + this.keyword.length();
    }

    public Object peekValue() {
        for (Object object : this.children) {
            if (object instanceof Element) continue;
            return object;
        }
        return null;
    }

    public Temporal pullTime(String key) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Temporal)) continue;
            iterator.remove();
            return (Temporal)object;
        }
        throw this.missingComponent(key);
    }

    public double pullDouble(String key) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            return ((Number)object).doubleValue();
        }
        throw this.missingComponent(key);
    }

    public int pullInteger(String key) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Number)) continue;
            iterator.remove();
            Number number = (Number)object;
            if (number instanceof Float || number instanceof Double) {
                throw new UnparsableObjectException(this.errorLocale, 186, new Object[]{Integer.class, number}, this.offset);
            }
            return number.intValue();
        }
        throw this.missingComponent(key);
    }

    public boolean pullBoolean(String key) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Boolean)) continue;
            iterator.remove();
            return (Boolean)object;
        }
        throw this.missingComponent(key);
    }

    public String pullString(String key) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.remove();
            return (String)object;
        }
        throw this.missingComponent(key);
    }

    public Object pullObject(String key) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null || object instanceof Element) continue;
            iterator.remove();
            return object;
        }
        throw this.missingComponent(key);
    }

    public Element pullElement(int mode, String ... keys) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (element.isEnumeration) continue;
            for (int i = 0; i < keys.length; ++i) {
                if (!element.keyword.equalsIgnoreCase(keys[i])) continue;
                element.keywordIndex = (byte)i;
                iterator.remove();
                return element;
            }
            if (mode != 0) continue;
            return null;
        }
        if (mode != 2) {
            return null;
        }
        throw this.missingComponent(keys[0]);
    }

    public Element pullVoidElement(String key) throws ParseException {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof Element)) continue;
            Element element = (Element)object;
            if (!element.isEnumeration) continue;
            iterator.remove();
            return element;
        }
        throw this.missingComponent(key);
    }

    public <T> T pullOptional(Class<T> type) {
        Iterator<Object> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!type.isInstance(object) || object instanceof Element) continue;
            iterator.remove();
            return (T)object;
        }
        return null;
    }

    final Object[] getChildren() {
        return this.isEnumeration ? null : this.children.toArray();
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    final int getKeywordIndex() {
        return Byte.toUnsignedInt(this.keywordIndex);
    }

    final void close(Map<String, Set<String>> ignoredElements) throws ParseException {
        for (Object value : this.children) {
            if (value instanceof Element) {
                ignoredElements.computeIfAbsent(((Element)value).keyword, key -> new LinkedHashSet()).add(this.keyword);
                continue;
            }
            throw new UnparsableObjectException(this.errorLocale, 176, new Object[]{this.keyword, value}, this.offsetAfterKeyword());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.format(buffer, 0, System.lineSeparator());
        return buffer.toString();
    }

    private void format(StringBuilder buffer, int margin, String lineSeparator) {
        buffer.append(CharSequences.spaces((int)margin)).append(this.keyword);
        if (!this.isEnumeration) {
            buffer.append('[');
            margin += 4;
            boolean addSeparator = false;
            for (Object value : this.children) {
                if (value instanceof Element) {
                    if (addSeparator) {
                        buffer.append(',');
                    }
                    buffer.append(lineSeparator);
                    ((Element)value).format(buffer, margin, lineSeparator);
                } else {
                    boolean quote = value instanceof CharSequence;
                    if (addSeparator) {
                        buffer.append(", ");
                    }
                    if (quote) {
                        buffer.append('\u201c');
                    }
                    buffer.append(value);
                    if (quote) {
                        buffer.append('\u201d');
                    }
                }
                addSeparator = true;
            }
            buffer.append(']');
        }
    }
}

