/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.Objects;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.PropertyView;
import org.opengis.util.GenericName;

class AssociationView
extends AbstractAssociation {
    private static final long serialVersionUID = -148100967531766909L;
    final AbstractFeature feature;
    final String name;

    private AssociationView(AbstractFeature feature, DefaultAssociationRole role) {
        super(role);
        this.feature = feature;
        this.name = role.getName().toString();
    }

    static AbstractAssociation create(AbstractFeature feature, DefaultAssociationRole role) {
        if (AssociationView.isSingleton(role.getMaximumOccurs())) {
            return new Singleton(feature, role);
        }
        return new AssociationView(feature, role);
    }

    @Override
    public final GenericName getName() {
        return this.role.getName();
    }

    @Override
    public AbstractFeature getValue() {
        return (AbstractFeature)PropertyView.getValue(this.feature, this.name);
    }

    @Override
    public void setValue(AbstractFeature value) {
        PropertyView.setValue(this.feature, this.name, value);
    }

    @Override
    public Collection<AbstractFeature> getValues() {
        return PropertyView.getValues(this.feature, this.name, AbstractFeature.class);
    }

    @Override
    public final void setValues(Collection<? extends AbstractFeature> values) {
        PropertyView.setValues(this.feature, this.name, values);
    }

    public final int hashCode() {
        return PropertyView.hashCode(this.feature, this.name);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            AssociationView that = (AssociationView)obj;
            return this.feature == that.feature && Objects.equals(this.name, that.name);
        }
        return false;
    }

    @Override
    public final String toString() {
        return PropertyView.toString(this.getClass(), AbstractFeature.class, this.getName(), this.getValues());
    }

    private static final class Singleton
    extends AssociationView {
        private static final long serialVersionUID = 2574475751526292380L;

        Singleton(AbstractFeature feature, DefaultAssociationRole role) {
            super(feature, role);
        }

        @Override
        public AbstractFeature getValue() {
            return (AbstractFeature)this.feature.getPropertyValue(this.name);
        }

        @Override
        public void setValue(AbstractFeature value) {
            this.feature.setPropertyValue(this.name, value);
        }

        @Override
        public Collection<AbstractFeature> getValues() {
            return PropertyView.singletonOrEmpty(this.getValue());
        }
    }
}

