/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.panama;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.UndeclaredThrowableException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Callable;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.panama.LibraryLoader;
import org.apache.sis.util.collection.BackingStoreException;

public abstract class NativeFunctions
implements Runnable,
Callable<Object> {
    public final String libraryName;
    private final Arena arena;
    public final SymbolLookup symbols;
    public final Linker linker;

    protected NativeFunctions(LibraryLoader<?> loader) {
        this.libraryName = loader.filename;
        this.arena = loader.arena;
        this.symbols = loader.symbols;
        this.linker = Linker.nativeLinker();
    }

    protected final Arena arena() {
        return this.arena != null ? this.arena : Arena.global();
    }

    public final MethodHandle lookup(String function, FunctionDescriptor signature) {
        return this.symbols.find(function).map(method -> this.linker.downcallHandle((MemorySegment)method, signature, new Linker.Option[0])).orElseThrow();
    }

    protected final Optional<String> invokeGetString(String function, String arg) {
        return this.symbols.find(function).map(method -> {
            MemorySegment result;
            MethodHandle handle = this.lookup(function, FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS));
            try (Arena local = Arena.ofConfined();){
                result = handle.invokeExact(local.allocateFrom(arg));
            }
            catch (Throwable e) {
                throw NativeFunctions.propagate(e);
            }
            return NativeFunctions.toString(result);
        });
    }

    public final OptionalInt invokeGetInt(String function) {
        int result;
        Optional<MemorySegment> method = this.symbols.find(function);
        if (method.isEmpty()) {
            return OptionalInt.empty();
        }
        MethodHandle handle = this.linker.downcallHandle(method.get(), FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]), new Linker.Option[0]);
        try {
            result = handle.invokeExact();
        }
        catch (Throwable e) {
            throw NativeFunctions.propagate(e);
        }
        return OptionalInt.of(result);
    }

    protected final boolean invoke(String function) {
        Optional<MemorySegment> method = this.symbols.find(function);
        if (method.isEmpty()) {
            return false;
        }
        MethodHandle handle = this.linker.downcallHandle(method.get(), FunctionDescriptor.ofVoid(new MemoryLayout[0]), new Linker.Option[0]);
        try {
            handle.invokeExact();
        }
        catch (Throwable e) {
            throw NativeFunctions.propagate(e);
        }
        return true;
    }

    @Override
    public void run() {
        if (this.arena != null) {
            this.arena.close();
        }
    }

    @Override
    public final Object call() {
        this.run();
        return null;
    }

    public static boolean isNull(MemorySegment result) {
        return result == null || result.address() == 0L;
    }

    public static String toString(MemorySegment result) {
        return NativeFunctions.isNull(result) ? null : result.reinterpret(Integer.MAX_VALUE).getString(0L);
    }

    public static RuntimeException propagate(Throwable exception) {
        Throwable throwable = exception;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Error.class, RuntimeException.class, IOException.class, DataStoreException.class}, (Object)throwable2, n)) {
            case 0: {
                Error e = (Error)throwable2;
                throw e;
            }
            case 1: {
                RuntimeException e = (RuntimeException)throwable2;
                return e;
            }
            case 2: {
                IOException e = (IOException)throwable2;
                return new UncheckedIOException(e);
            }
            case 3: {
                DataStoreException e = (DataStoreException)throwable2;
                return new BackingStoreException((Throwable)e);
            }
        }
        return new UndeclaredThrowableException(exception);
    }
}

