/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gdal;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.logging.Logger;
import org.apache.sis.image.internal.shared.AssertionMessages;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.TiledGridCoverage;
import org.apache.sis.storage.base.TiledGridResource;
import org.apache.sis.storage.gdal.Band;
import org.apache.sis.storage.gdal.DataType;
import org.apache.sis.storage.gdal.ErrorHandler;
import org.apache.sis.storage.gdal.GDAL;
import org.apache.sis.storage.gdal.GDALStore;
import org.apache.sis.storage.gdal.GDALStoreProvider;
import org.apache.sis.storage.gdal.TiledResource;
import org.apache.sis.util.logging.Logging;
import org.opengis.util.GenericName;

final class TiledCoverage
extends TiledGridCoverage {
    private final TiledResource owner;

    TiledCoverage(TiledResource owner, TiledGridResource.Subset subset) {
        super(subset);
        this.owner = owner;
    }

    protected GenericName getIdentifier() {
        return this.owner.getIdentifier().orElse(null);
    }

    private long getTileLength() {
        return Math.ceilDiv(Math.multiplyFull(this.model.getWidth(), this.model.getHeight()) * (long)this.owner.dataType.numBits, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Raster[] readTiles(TiledGridCoverage.TileIterator iterator) throws IOException, DataStoreException {
        Rectangle imageBounds;
        Rectangle resourceBounds = this.bidimensional(iterator.getFullRegionInResourceCoordinates());
        try {
            imageBounds = iterator.resourceToImage(resourceBounds, false);
        }
        catch (ArithmeticException e) {
            Logging.ignorableException((Logger)GDALStoreProvider.LOGGER, GDALStore.class, (String)"read", (Throwable)e);
            imageBounds = null;
        }
        Object object = this.owner.getSynchronizationLock();
        synchronized (object) {
            Band[] bands = this.owner.bands(this.includedBands);
            GDAL gdal = this.owner.parent.getProvider().GDAL();
            DataType rasterType = this.owner.dataType.forDataBufferType(this.model.getDataType());
            if (imageBounds != null) {
                for (Band band : bands) {
                    if (!band.adviseRead(gdal, resourceBounds, imageBounds, rasterType)) break;
                }
            }
            Raster[] result = new WritableRaster[iterator.tileCountInQuery];
            try (Arena arena = Arena.ofConfined();){
                MemorySegment transferBuffer = arena.allocate(this.getTileLength());
                do {
                    WritableRaster tile = iterator.createRaster();
                    Rectangle rasterBounds = iterator.getRegionInsideTile(true);
                    if (rasterBounds != null) {
                        rasterBounds.translate(tile.getMinX(), tile.getMinY());
                        assert (imageBounds == null || imageBounds.contains(rasterBounds)) : AssertionMessages.notContained((Rectangle)imageBounds, (Rectangle)rasterBounds);
                        resourceBounds = iterator.imageToResource(rasterBounds, false);
                        this.owner.clipReadRegion(resourceBounds);
                        iterator.getUncroppedTileLocation().ifPresent(p -> rasterBounds.translate(p.x, p.y));
                        if (!Band.transfer(gdal, 0, bands, this.owner.dataType, resourceBounds, tile, rasterBounds, transferBuffer)) {
                            break;
                        }
                    }
                    result[iterator.getTileIndexInResultArray()] = tile;
                } while (iterator.next());
            }
            finally {
                ErrorHandler.throwOnFailure(this.owner.parent, "read");
            }
            return result;
        }
    }
}

