/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql.internal.shared;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.sis.util.CharSequences;

public enum Dialect {
    ANSI(null, 964),
    DERBY("derby", 196),
    HSQL("hsqldb", 452),
    POSTGRESQL("postgresql", 1021),
    ORACLE("oracle", 964),
    SQLITE("sqlite", 512),
    DUCKDB("duckdb", 0);

    private final String protocol;
    private final int flags;

    private Dialect(String protocol, int flags) {
        this.protocol = protocol;
        this.flags = flags;
    }

    public final boolean supportsTableInheritance() {
        return (this.flags & 1) != 0;
    }

    public final boolean supportsIndexInheritance() {
        return (this.flags & 2) != 0;
    }

    public final boolean supportsAlterTableWithAddConstraint() {
        return (this.flags & 4) != 0;
    }

    public final boolean supportsGrantUsageOnSchema() {
        return (this.flags & 8) != 0;
    }

    public final boolean supportsGrantSelectOnTable() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean supportsAllGrants() {
        return (this.flags & 0x18) == 24;
    }

    public final boolean supportsComment() {
        return (this.flags & 0x20) != 0;
    }

    public final boolean supportsReadOnlyUpdate() {
        return (this.flags & 0x40) != 0;
    }

    public final boolean supportsConcurrency() {
        return (this.flags & 0x80) != 0;
    }

    public final boolean supportsJavaTime() {
        return (this.flags & 0x100) != 0;
    }

    public final boolean supportsSRID() {
        return (this.flags & 0x200) != 0;
    }

    public static Dialect guess(DatabaseMetaData metadata) throws SQLException {
        int end;
        int start;
        String url = metadata.getURL();
        if (url != null && (start = url.indexOf(58)) >= 0 && "jdbc".equalsIgnoreCase((String)CharSequences.trimWhitespaces((CharSequence)url, (int)0, (int)start)) && (end = url.indexOf(58, ++start)) >= 0) {
            String protocol = (String)CharSequences.trimWhitespaces((CharSequence)url, (int)start, (int)end);
            for (Dialect candidate : Dialect.values()) {
                if (!protocol.equalsIgnoreCase(candidate.protocol)) continue;
                return candidate;
            }
        }
        return ANSI;
    }
}

