/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.internal.shared.ImplementationHelper;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.IdentifiedObject;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.bind.IdentifierMapAdapter;
import org.apache.sis.xml.bind.ModifiableIdentifierMap;
import org.apache.sis.xml.bind.NonMarshalledAuthority;
import org.opengis.metadata.Identifier;

@XmlTransient
public class ISOMetadata
extends ModifiableMetadata
implements IdentifiedObject,
Serializable {
    private static final long serialVersionUID = -4997239501383133209L;
    protected Collection<Identifier> identifiers;

    protected ISOMetadata() {
    }

    protected ISOMetadata(Object object) {
        super(object);
        if (object instanceof IdentifiedObject) {
            if (object instanceof ISOMetadata && Containers.isNullOrEmpty(((ISOMetadata)object).identifiers) && object.getClass().getName().startsWith("org.apache.sis.")) {
                return;
            }
            this.identifiers = ISOMetadata.copyCollection(((IdentifiedObject)object).getIdentifiers(), Identifier.class);
        }
    }

    @Override
    public MetadataStandard getStandard() {
        return MetadataStandard.ISO_19115;
    }

    public Collection<Identifier> getIdentifiers() {
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        return this.identifiers;
    }

    @Override
    public IdentifierMap getIdentifierMap() {
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        if (this.identifiers == null) {
            return IdentifierMapAdapter.EMPTY;
        }
        return super.state() != ModifiableMetadata.State.FINAL ? new ModifiableIdentifierMap(this.identifiers) : new IdentifierMapAdapter(this.identifiers);
    }

    protected Identifier getIdentifier() {
        return NonMarshalledAuthority.getMarshallable(this.identifiers);
    }

    protected void setIdentifier(Identifier newValue) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.identifiers));
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        this.identifiers = this.writeCollection(NonMarshalledAuthority.setMarshallable(this.identifiers, newValue), this.identifiers, Identifier.class);
    }

    @Override
    public boolean transitionTo(ModifiableMetadata.State target) {
        Collection<Identifier> p = this.identifiers;
        boolean changed = super.transitionTo(target);
        if (changed && p != null && p == this.identifiers) {
            this.identifiers = p instanceof Set ? Containers.unmodifiable((Set)((Set)p)) : (p instanceof List ? Containers.unmodifiable((List)((List)p)) : Collections.unmodifiableCollection(p));
        }
        return changed;
    }

    @XmlID
    @XmlAttribute
    @XmlSchemaType(name="ID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : ImplementationHelper.getObjectID(this);
    }

    private void setID(String id) {
        ImplementationHelper.setObjectID(this, id);
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    private String getUUID() {
        return Containers.isNullOrEmpty(this.identifiers) ? null : (String)this.getIdentifierMap().get(IdentifierSpace.UUID);
    }

    private void setUUID(String id) {
        this.getIdentifierMap().put(IdentifierSpace.UUID, id);
    }
}

