/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.ch.qos.logback.core.model;

import java.util.Properties;
import org.apache.rocketmq.shaded.ch.qos.logback.core.joran.action.ActionUtil;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.Model;
import org.apache.rocketmq.shaded.ch.qos.logback.core.model.processor.ModelInterpretationContext;
import org.apache.rocketmq.shaded.ch.qos.logback.core.util.ContextUtil;
import org.apache.rocketmq.shaded.ch.qos.logback.core.util.OptionHelper;

public class ModelUtil {
    public static void resetForReuse(Model model) {
        if (model == null) {
            return;
        }
        model.resetForReuse();
    }

    public static void setProperty(ModelInterpretationContext mic, String key, String value, ActionUtil.Scope scope) {
        switch (scope) {
            case LOCAL: {
                mic.addSubstitutionProperty(key, value);
                break;
            }
            case CONTEXT: {
                mic.getContext().putProperty(key, value);
                break;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperty(mic, key, value);
            }
        }
    }

    public static void setProperties(ModelInterpretationContext ic, Properties props, ActionUtil.Scope scope) {
        switch (scope) {
            case LOCAL: {
                ic.addSubstitutionProperties(props);
                break;
            }
            case CONTEXT: {
                ContextUtil cu = new ContextUtil(ic.getContext());
                cu.addProperties(props);
                break;
            }
            case SYSTEM: {
                OptionHelper.setSystemProperties(ic, props);
            }
        }
    }
}

