/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.ChannelMethodProcessor;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;

public class ChannelFlowOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 21;
    private final boolean _active;

    public ChannelFlowOkBody(boolean active) {
        this._active = active;
    }

    @Override
    public int getClazz() {
        return 20;
    }

    @Override
    public int getMethod() {
        return 21;
    }

    public final boolean getActive() {
        return this._active;
    }

    @Override
    protected int getBodySize() {
        int size = 1;
        return size;
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeBitfield(buffer, this._active ? (byte)1 : 0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchChannelFlowOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ChannelFlowOkBodyImpl: ");
        buf.append("active=");
        buf.append(this.getActive());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ChannelMethodProcessor dispatcher) {
        boolean active;
        boolean bl = active = (buffer.get() & 1) == 1;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveChannelFlowOk(active);
        }
    }
}

