/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v106.fetch.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v106.fetch.model.AuthChallenge;
import org.openqa.selenium.devtools.v106.fetch.model.RequestId;
import org.openqa.selenium.devtools.v106.network.model.Request;
import org.openqa.selenium.devtools.v106.network.model.ResourceType;
import org.openqa.selenium.devtools.v106.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class AuthRequired {
    private final RequestId requestId;
    private final Request request;
    private final FrameId frameId;
    private final ResourceType resourceType;
    private final AuthChallenge authChallenge;

    public AuthRequired(RequestId requestId, Request request, FrameId frameId, ResourceType resourceType, AuthChallenge authChallenge) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.request = Objects.requireNonNull(request, "request is required");
        this.frameId = Objects.requireNonNull(frameId, "frameId is required");
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType is required");
        this.authChallenge = Objects.requireNonNull(authChallenge, "authChallenge is required");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public Request getRequest() {
        return this.request;
    }

    public FrameId getFrameId() {
        return this.frameId;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public AuthChallenge getAuthChallenge() {
        return this.authChallenge;
    }

    private static AuthRequired fromJson(JsonInput input) {
        RequestId requestId = null;
        Request request = null;
        FrameId frameId = null;
        ResourceType resourceType = null;
        AuthChallenge authChallenge = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block14;
                }
                case "request": {
                    request = (Request)input.read(Request.class);
                    continue block14;
                }
                case "frameId": {
                    frameId = (FrameId)input.read(FrameId.class);
                    continue block14;
                }
                case "resourceType": {
                    resourceType = (ResourceType)((Object)input.read(ResourceType.class));
                    continue block14;
                }
                case "authChallenge": {
                    authChallenge = (AuthChallenge)input.read(AuthChallenge.class);
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AuthRequired(requestId, request, frameId, resourceType, authChallenge);
    }
}

