/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.sitemaps.extension.Extension;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Namespace {
    public static final String SITEMAP = "http://www.sitemaps.org/schemas/sitemap/0.9";
    public static final String[] SITEMAP_LEGACY = new String[]{"https://www.sitemaps.org/schemas/sitemap/0.9", "http://www.sitemaps.org/schemas/sitemap/0.9/", "https://www.sitemaps.org/schemas/sitemap/0.9/", "http://www.google.com/schemas/sitemap/0.9", "https://www.google.com/schemas/sitemap/0.9", "http://www.google.com/schemas/sitemap/0.84", "https://www.google.com/schemas/sitemap/0.84", "http://www.google.com/schemas/sitemap/0.90", "https://sitemaps.org/schemas/sitemap/0.9"};
    public static final String[] IMAGE = new String[]{"http://www.google.com/schemas/sitemap-image/1.1", "https://www.google.com/schemas/sitemap-image/1.1"};
    public static final String[] VIDEO = new String[]{"http://www.google.com/schemas/sitemap-video/1.1", "https://www.google.com/schemas/sitemap-video/1.1"};
    public static final String[] NEWS = new String[]{"http://www.google.com/schemas/sitemap-news/0.9", "https://www.google.com/schemas/sitemap-news/0.9", "http://www.google.com/schemas/sitemap-news/0.84", "https://www.google.com/schemas/sitemap-news/0.84"};
    public static final String[] MOBILE = new String[]{"http://www.google.com/schemas/sitemap-mobile/1.0", "https://www.google.com/schemas/sitemap-mobile/1.0"};
    public static final String[] LINKS = new String[]{"http://www.w3.org/1999/xhtml", "https://www.w3.org/1999/xhtml"};
    public static final String[] PAGEMAPS = new String[]{"http://www.google.com/schemas/sitemap-pagemap/1.0", "https://www.google.com/schemas/sitemap-pagemap/1.0"};
    public static final String EMPTY = "";
    public static final String RSS_2_0 = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    public static final String ATOM_0_3 = "http://purl.org/atom/ns#";
    public static final String ATOM_1_0 = "http://www.w3.org/2005/Atom";
    public static final Set<String> SITEMAP_SUPPORTED_NAMESPACES = new HashSet<String>();
    public static final Map<Extension, List<String>> SITEMAP_EXTENSION_NAMESPACES;

    public static boolean isSupported(String uri) {
        return SITEMAP_SUPPORTED_NAMESPACES.contains(uri);
    }

    static {
        SITEMAP_SUPPORTED_NAMESPACES.add(SITEMAP);
        SITEMAP_SUPPORTED_NAMESPACES.addAll(Arrays.asList(SITEMAP_LEGACY));
        SITEMAP_SUPPORTED_NAMESPACES.addAll(Arrays.asList(IMAGE));
        SITEMAP_SUPPORTED_NAMESPACES.addAll(Arrays.asList(VIDEO));
        SITEMAP_SUPPORTED_NAMESPACES.addAll(Arrays.asList(NEWS));
        SITEMAP_SUPPORTED_NAMESPACES.addAll(Arrays.asList(LINKS));
        SITEMAP_SUPPORTED_NAMESPACES.addAll(Arrays.asList(PAGEMAPS));
        SITEMAP_EXTENSION_NAMESPACES = new TreeMap<Extension, List<String>>();
        SITEMAP_EXTENSION_NAMESPACES.put(Extension.NEWS, Arrays.asList(NEWS));
        SITEMAP_EXTENSION_NAMESPACES.put(Extension.IMAGE, Arrays.asList(IMAGE));
        SITEMAP_EXTENSION_NAMESPACES.put(Extension.VIDEO, Arrays.asList(VIDEO));
        SITEMAP_EXTENSION_NAMESPACES.put(Extension.MOBILE, Arrays.asList(MOBILE));
        SITEMAP_EXTENSION_NAMESPACES.put(Extension.LINKS, Arrays.asList(LINKS));
        SITEMAP_EXTENSION_NAMESPACES.put(Extension.PAGEMAPS, Arrays.asList(PAGEMAPS));
    }
}

