/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.domains;

import crawlercommons.domains.EffectiveTldFinder;
import java.net.URL;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaidLevelDomain {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaidLevelDomain.class);
    private static final Pattern IPV4_ADDRESS_PATTERN = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");

    public static String getPLD(String hostname) {
        if (hostname.startsWith("[") && hostname.endsWith("]")) {
            return hostname;
        }
        if (IPV4_ADDRESS_PATTERN.matcher(hostname).matches()) {
            return hostname;
        }
        String result = EffectiveTldFinder.getAssignedDomain(hostname, true, true);
        if (result == null) {
            LOGGER.debug("Hostname {} isn't a valid FQDN", (Object)hostname);
            return hostname;
        }
        return result;
    }

    public static String getPLD(URL url) {
        return PaidLevelDomain.getPLD(url.getHost());
    }
}

