/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase.highlight;

import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.index.analysis.AnalyzerComponentsProvider;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.analysis.TokenFilterFactory;
import org.opensearch.index.mapper.MappedFieldType;

public final class FragmentBuilderHelper {
    private FragmentBuilderHelper() {
    }

    public static FieldFragList.WeightedFragInfo fixWeightedFragInfo(MappedFieldType fieldType, Field[] values, FieldFragList.WeightedFragInfo fragInfo) {
        assert (fragInfo != null) : "FragInfo must not be null";
        assert (fieldType.name().equals(values[0].name())) : "Expected MappedFieldType for field " + values[0].name();
        if (!fragInfo.getSubInfos().isEmpty() && FragmentBuilderHelper.containsBrokenAnalysis((Analyzer)fieldType.indexAnalyzer())) {
            List subInfos = fragInfo.getSubInfos();
            CollectionUtil.introSort((List)subInfos, (Comparator)new Comparator<FieldFragList.WeightedFragInfo.SubInfo>(){

                @Override
                public int compare(FieldFragList.WeightedFragInfo.SubInfo o1, FieldFragList.WeightedFragInfo.SubInfo o2) {
                    int startOffset = ((FieldPhraseList.WeightedPhraseInfo.Toffs)o1.getTermsOffsets().get(0)).getStartOffset();
                    int startOffset2 = ((FieldPhraseList.WeightedPhraseInfo.Toffs)o2.getTermsOffsets().get(0)).getStartOffset();
                    return FragmentBuilderHelper.compare(startOffset, startOffset2);
                }
            });
            return new FieldFragList.WeightedFragInfo(Math.min(((FieldPhraseList.WeightedPhraseInfo.Toffs)((FieldFragList.WeightedFragInfo.SubInfo)fragInfo.getSubInfos().get(0)).getTermsOffsets().get(0)).getStartOffset(), fragInfo.getStartOffset()), fragInfo.getEndOffset(), subInfos, fragInfo.getTotalBoost());
        }
        return fragInfo;
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static boolean containsBrokenAnalysis(Analyzer analyzer) {
        if (analyzer instanceof NamedAnalyzer) {
            analyzer = ((NamedAnalyzer)analyzer).analyzer();
        }
        if (analyzer instanceof AnalyzerComponentsProvider) {
            TokenFilterFactory[] tokenFilters;
            for (TokenFilterFactory tokenFilterFactory : tokenFilters = ((AnalyzerComponentsProvider)analyzer).getComponents().getTokenFilters()) {
                if (!tokenFilterFactory.breaksFastVectorHighlighter()) continue;
                return true;
            }
        }
        return false;
    }
}

