/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.util.List;
import java.util.Map;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.query.QueryShardContext;

public abstract class ConstantFieldType
extends MappedFieldType {
    public ConstantFieldType(String name, Map<String, String> meta) {
        super(name, true, false, true, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
    }

    @Override
    public final boolean isSearchable() {
        return true;
    }

    @Override
    public final boolean isAggregatable() {
        return true;
    }

    protected abstract boolean matches(String var1, boolean var2, QueryShardContext var3);

    private static String valueToString(Object value) {
        return value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
    }

    @Override
    public final Query termQuery(Object value, QueryShardContext context) {
        String pattern = ConstantFieldType.valueToString(value);
        if (this.matches(pattern, false, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query termQueryCaseInsensitive(Object value, QueryShardContext context) {
        String pattern = ConstantFieldType.valueToString(value);
        if (this.matches(pattern, true, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query termsQuery(List<?> values, QueryShardContext context) {
        for (Object value : values) {
            String pattern = ConstantFieldType.valueToString(value);
            if (!this.matches(pattern, false, context)) continue;
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query prefixQuery(String prefix, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
        String pattern = prefix + "*";
        if (this.matches(pattern, caseInsensitive, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }

    @Override
    public final Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
        if (this.matches(value, caseInsensitive, context)) {
            return Queries.newMatchAllQuery();
        }
        return new MatchNoDocsQuery();
    }
}

