/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation.decider;

import java.util.Map;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeFilters;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.opensearch.cluster.routing.allocation.decider.Decision;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;

public class FilterAllocationDecider
extends AllocationDecider {
    public static final String NAME = "filter";
    private static final String CLUSTER_ROUTING_REQUIRE_GROUP_PREFIX = "cluster.routing.allocation.require";
    private static final String CLUSTER_ROUTING_INCLUDE_GROUP_PREFIX = "cluster.routing.allocation.include";
    private static final String CLUSTER_ROUTING_EXCLUDE_GROUP_PREFIX = "cluster.routing.allocation.exclude";
    public static final Setting.AffixSetting<String> CLUSTER_ROUTING_REQUIRE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.require.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    public static final Setting.AffixSetting<String> CLUSTER_ROUTING_INCLUDE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.include.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    public static final Setting.AffixSetting<String> CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING = Setting.prefixKeySetting("cluster.routing.allocation.exclude.", key -> Setting.simpleString(key, value -> DiscoveryNodeFilters.IP_VALIDATOR.accept((String)key, (String)value), Setting.Property.Dynamic, Setting.Property.NodeScope));
    private volatile DiscoveryNodeFilters clusterRequireFilters;
    private volatile DiscoveryNodeFilters clusterIncludeFilters;
    private volatile DiscoveryNodeFilters clusterExcludeFilters;

    public FilterAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.setClusterRequireFilters(CLUSTER_ROUTING_REQUIRE_GROUP_SETTING.getAsMap(settings));
        this.setClusterExcludeFilters(CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING.getAsMap(settings));
        this.setClusterIncludeFilters(CLUSTER_ROUTING_INCLUDE_GROUP_SETTING.getAsMap(settings));
        clusterSettings.addAffixMapUpdateConsumer(CLUSTER_ROUTING_REQUIRE_GROUP_SETTING, this::setClusterRequireFilters, (a, b) -> {});
        clusterSettings.addAffixMapUpdateConsumer(CLUSTER_ROUTING_EXCLUDE_GROUP_SETTING, this::setClusterExcludeFilters, (a, b) -> {});
        clusterSettings.addAffixMapUpdateConsumer(CLUSTER_ROUTING_INCLUDE_GROUP_SETTING, this::setClusterIncludeFilters, (a, b) -> {});
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetadata indexMd;
        DiscoveryNodeFilters initialRecoveryFilters;
        if (shardRouting.unassigned() && (initialRecoveryFilters = DiscoveryNodeFilters.trimTier((indexMd = allocation.metadata().getIndexSafe(shardRouting.index())).getInitialRecoveryFilters())) != null && shardRouting.recoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS && !initialRecoveryFilters.match(node.node())) {
            String explanation = "initial allocation of the shrunken index is only allowed on nodes [%s] that hold a copy of every shard in the index";
            return allocation.decision(Decision.NO, NAME, explanation, initialRecoveryFilters);
        }
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    @Override
    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(indexMetadata, node.node(), allocation);
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node.node(), allocation);
    }

    @Override
    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(indexMetadata, node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    @Override
    public Decision canAllocateAnyShardToNode(RoutingNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node.node(), allocation);
        return decision != null && decision == Decision.NO ? decision : Decision.ALWAYS;
    }

    private Decision shouldFilter(ShardRouting shardRouting, DiscoveryNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(allocation.metadata().getIndexSafe(shardRouting.index()), node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    private Decision shouldFilter(IndexMetadata indexMd, DiscoveryNode node, RoutingAllocation allocation) {
        Decision decision = this.shouldClusterFilter(node, allocation);
        if (decision != null) {
            return decision;
        }
        decision = this.shouldIndexFilter(indexMd, node, allocation);
        if (decision != null) {
            return decision;
        }
        return allocation.decision(Decision.YES, NAME, "node passes include/exclude/require filters", new Object[0]);
    }

    private Decision shouldIndexFilter(IndexMetadata indexMd, DiscoveryNode node, RoutingAllocation allocation) {
        DiscoveryNodeFilters indexRequireFilters = DiscoveryNodeFilters.trimTier(indexMd.requireFilters());
        DiscoveryNodeFilters indexIncludeFilters = DiscoveryNodeFilters.trimTier(indexMd.includeFilters());
        DiscoveryNodeFilters indexExcludeFilters = DiscoveryNodeFilters.trimTier(indexMd.excludeFilters());
        if (indexRequireFilters != null && !indexRequireFilters.match(node)) {
            return allocation.decision(Decision.NO, NAME, "node does not match index setting [%s] filters [%s]", "index.routing.allocation.require", indexRequireFilters);
        }
        if (indexIncludeFilters != null && !indexIncludeFilters.match(node)) {
            return allocation.decision(Decision.NO, NAME, "node does not match index setting [%s] filters [%s]", "index.routing.allocation.include", indexIncludeFilters);
        }
        if (indexExcludeFilters != null && indexExcludeFilters.match(node)) {
            return allocation.decision(Decision.NO, NAME, "node matches index setting [%s] filters [%s]", IndexMetadata.INDEX_ROUTING_EXCLUDE_GROUP_SETTING.getKey(), indexExcludeFilters);
        }
        return null;
    }

    private Decision shouldClusterFilter(DiscoveryNode node, RoutingAllocation allocation) {
        if (this.clusterRequireFilters != null && !this.clusterRequireFilters.match(node)) {
            return allocation.decision(Decision.NO, NAME, "node does not match cluster setting [%s] filters [%s]", CLUSTER_ROUTING_REQUIRE_GROUP_PREFIX, this.clusterRequireFilters);
        }
        if (this.clusterIncludeFilters != null && !this.clusterIncludeFilters.match(node)) {
            return allocation.decision(Decision.NO, NAME, "node does not cluster setting [%s] filters [%s]", CLUSTER_ROUTING_INCLUDE_GROUP_PREFIX, this.clusterIncludeFilters);
        }
        if (this.clusterExcludeFilters != null && this.clusterExcludeFilters.match(node)) {
            return allocation.decision(Decision.NO, NAME, "node matches cluster setting [%s] filters [%s]", CLUSTER_ROUTING_EXCLUDE_GROUP_PREFIX, this.clusterExcludeFilters);
        }
        return null;
    }

    private void setClusterRequireFilters(Map<String, String> filters) {
        this.clusterRequireFilters = DiscoveryNodeFilters.trimTier(DiscoveryNodeFilters.buildOrUpdateFromKeyValue(this.clusterRequireFilters, DiscoveryNodeFilters.OpType.AND, filters));
    }

    private void setClusterIncludeFilters(Map<String, String> filters) {
        this.clusterIncludeFilters = DiscoveryNodeFilters.trimTier(DiscoveryNodeFilters.buildOrUpdateFromKeyValue(this.clusterIncludeFilters, DiscoveryNodeFilters.OpType.OR, filters));
    }

    private void setClusterExcludeFilters(Map<String, String> filters) {
        this.clusterExcludeFilters = DiscoveryNodeFilters.trimTier(DiscoveryNodeFilters.buildOrUpdateFromKeyValue(this.clusterExcludeFilters, DiscoveryNodeFilters.OpType.OR, filters));
    }
}

