/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.input.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v108.input.model.DragDataItem;
import org.openqa.selenium.json.JsonInput;

@Beta
public class DragData {
    private final List<DragDataItem> items;
    private final Optional<List<String>> files;
    private final Integer dragOperationsMask;

    public DragData(List<DragDataItem> items, Optional<List<String>> files, Integer dragOperationsMask) {
        this.items = Objects.requireNonNull(items, "items is required");
        this.files = files;
        this.dragOperationsMask = Objects.requireNonNull(dragOperationsMask, "dragOperationsMask is required");
    }

    public List<DragDataItem> getItems() {
        return this.items;
    }

    public Optional<List<String>> getFiles() {
        return this.files;
    }

    public Integer getDragOperationsMask() {
        return this.dragOperationsMask;
    }

    private static DragData fromJson(JsonInput input) {
        List items = null;
        Optional<List<String>> files = Optional.empty();
        Integer dragOperationsMask = 0;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "items": {
                    items = (List)input.read(new TypeToken<List<DragDataItem>>(){}.getType());
                    continue block10;
                }
                case "files": {
                    files = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                    continue block10;
                }
                case "dragOperationsMask": {
                    dragOperationsMask = input.nextNumber().intValue();
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DragData(items, files, dragOperationsMask);
    }
}

