/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.util.LinkedHashMap;
import java.util.Map;
import org.archive.util.iterator.StringFilter;

public class CachingStringFilter
implements StringFilter {
    private LRUCache cache;
    private StringFilter inner;

    public CachingStringFilter(StringFilter inner, int max) {
        this.inner = inner;
        this.cache = new LRUCache(max);
    }

    @Override
    public boolean isFiltered(String text) {
        Boolean v = (Boolean)this.cache.remove(text);
        if (v == null) {
            v = this.inner.isFiltered(text);
        }
        this.cache.put(text, v);
        return v;
    }

    public class LRUCache
    extends LinkedHashMap<String, Boolean> {
        private static final long serialVersionUID = 1L;
        private int max = 100;

        public LRUCache(int max) {
            this.max = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > this.max;
        }
    }
}

