/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extract;

import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.extract.ResourceFactoryMapper;
import org.archive.resource.Resource;
import org.archive.resource.ResourceFactory;
import org.archive.resource.ResourceParseException;
import org.archive.resource.ResourceProducer;

public class ExtractingResourceProducer
implements ResourceProducer {
    private static final Logger LOG = Logger.getLogger(ExtractingResourceProducer.class.getName());
    private ResourceProducer producer;
    private ResourceFactoryMapper mapper;

    public ExtractingResourceProducer(ResourceProducer producer, ResourceFactoryMapper mapper) {
        this.producer = producer;
        this.mapper = mapper;
    }

    @Override
    public Resource getNext() throws ResourceParseException, IOException {
        Resource current = this.producer.getNext();
        if (current == null) {
            return null;
        }
        ResourceFactory f;
        while ((f = this.mapper.mapResourceToFactory(current)) != null) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(String.format(Locale.ROOT, "Extracting (%s) with (%s)\n", current.getClass().toString(), f.getClass().toString()));
            }
            current = f.getResource(current.getInputStream(), current.getMetaData(), current.getContainer());
        }
        return current;
    }

    @Override
    public void close() throws IOException {
        this.producer.close();
    }

    @Override
    public String getContext() {
        return this.producer.getContext();
    }
}

