/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools.arc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArcRecordReader
extends RecordReader<Text, BytesWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Configuration conf;
    protected long splitStart = 0L;
    protected long pos = 0L;
    protected long splitEnd = 0L;
    protected long splitLen = 0L;
    protected long fileLen = 0L;
    protected FSDataInputStream in;
    private static byte[] MAGIC = new byte[]{31, -117};

    public static boolean isMagic(byte[] input) {
        if (input == null || input.length != MAGIC.length) {
            return false;
        }
        for (int i = 0; i < MAGIC.length; ++i) {
            if (MAGIC[i] == input[i]) continue;
            return false;
        }
        return true;
    }

    public ArcRecordReader(Configuration conf, FileSplit split) throws IOException {
        Path path = split.getPath();
        FileSystem fs = path.getFileSystem(conf);
        this.fileLen = fs.getFileStatus(split.getPath()).getLen();
        this.conf = conf;
        this.in = fs.open(split.getPath());
        this.splitStart = split.getStart();
        this.splitEnd = this.splitStart + split.getLength();
        this.splitLen = split.getLength();
        this.in.seek(this.splitStart);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public Text createKey() {
        return (Text)ReflectionUtils.newInstance(Text.class, (Configuration)this.conf);
    }

    public BytesWritable createValue() {
        return (BytesWritable)ReflectionUtils.newInstance(BytesWritable.class, (Configuration)this.conf);
    }

    public long getPos() throws IOException {
        return this.in.getPos();
    }

    public float getProgress() throws IOException {
        if (this.splitEnd == this.splitStart) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.getPos() - this.splitStart) / (float)this.splitLen);
    }

    public BytesWritable getCurrentValue() {
        return new BytesWritable();
    }

    public Text getCurrentKey() {
        return new Text();
    }

    public boolean nextKeyValue() {
        return false;
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
    }

    public boolean next(Text key, BytesWritable value) throws IOException {
        try {
            ByteArrayOutputStream baos;
            long startRead = this.in.getPos();
            byte[] magicBuffer = null;
            while (true) {
                if (startRead >= this.splitEnd) {
                    return false;
                }
                boolean foundStart = false;
                block5: while (!foundStart) {
                    startRead = this.in.getPos();
                    magicBuffer = new byte[1024];
                    int read = this.in.read(magicBuffer);
                    if (read < 0) break;
                    for (int i = 0; i < read - 1; ++i) {
                        byte[] testMagic = new byte[2];
                        System.arraycopy(magicBuffer, i, testMagic, 0, 2);
                        if (!ArcRecordReader.isMagic(testMagic)) continue;
                        startRead += (long)i;
                        foundStart = true;
                        continue block5;
                    }
                }
                this.in.seek(startRead);
                baos = null;
                int totalRead = 0;
                try {
                    byte[] buffer = new byte[4096];
                    GZIPInputStream zin = new GZIPInputStream((InputStream)this.in);
                    int gzipRead = -1;
                    baos = new ByteArrayOutputStream();
                    while ((gzipRead = zin.read(buffer, 0, buffer.length)) != -1) {
                        baos.write(buffer, 0, gzipRead);
                        totalRead += gzipRead;
                    }
                }
                catch (Exception e) {
                    System.out.println("Ignoring position: " + startRead);
                    if (startRead + 1L >= this.fileLen) continue;
                    this.in.seek(startRead + 1L);
                    continue;
                }
                break;
            }
            byte[] content = baos.toByteArray();
            int eol = 0;
            for (int i = 0; i < content.length; ++i) {
                if (i <= 0 || content[i] != 10) continue;
                eol = i;
                break;
            }
            String header = new String(content, 0, eol).trim();
            byte[] raw = new byte[content.length - eol - 1];
            System.arraycopy(content, eol + 1, raw, 0, raw.length);
            Text keyText = key;
            keyText.set(header);
            BytesWritable valueBytes = value;
            valueBytes.set(raw, 0, raw.length);
            if (startRead + 1L < this.fileLen) {
                this.in.seek(startRead + 1L);
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed reading ARC record: ", (Throwable)e);
            return false;
        }
    }
}

