/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.blueprint.ComponentDefinitionRegistry;
import org.apache.aries.transaction.BundleWideTxData;
import org.apache.aries.transaction.BundleWideTxDataUtil;
import org.apache.aries.transaction.Constants;
import org.apache.aries.transaction.TxComponentMetaDataHelper;
import org.apache.aries.transaction.annotations.TransactionPropagationType;
import org.osgi.service.blueprint.reflect.ComponentMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxComponentMetaDataHelperImpl
implements TxComponentMetaDataHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(TxComponentMetaDataHelperImpl.class);
    private static final Map<ComponentMetadata, TranData> data = new ConcurrentHashMap<ComponentMetadata, TranData>();
    private static final ConcurrentHashMap<ComponentDefinitionRegistry, List<BundleWideTxData>> bundleTransactionMap = new ConcurrentHashMap();
    private static final ConcurrentMap<ComponentDefinitionRegistry, Collection<ComponentMetadata>> dataForCDR = new ConcurrentHashMap<ComponentDefinitionRegistry, Collection<ComponentMetadata>>();

    @Override
    public void unregister(ComponentDefinitionRegistry registry) {
        Collection components = (Collection)dataForCDR.remove(registry);
        bundleTransactionMap.remove(registry);
        if (components != null) {
            for (ComponentMetadata meta : components) {
                data.remove(meta);
            }
        }
    }

    @Override
    public synchronized void setComponentTransactionData(ComponentDefinitionRegistry registry, ComponentMetadata component, TransactionPropagationType txType, String method) {
        LOGGER.debug("Parser setting comp trans data for bean {}, method {} to {} ", new Object[]{component.getId(), method, txType});
        TranData td = data.get(component);
        if (td == null) {
            td = new TranData();
            data.put(component, td);
            dataForCDR.putIfAbsent(registry, new HashSet());
            ((Collection)dataForCDR.get(registry)).add(component);
        }
        if (method == null || method.length() == 0) {
            method = "*";
        }
        if (txType == null) {
            txType = TransactionPropagationType.Required;
        }
        String[] names = method.split("[, \t]");
        for (int i = 0; i < names.length; ++i) {
            Pattern pattern = Pattern.compile(names[i].replaceAll("\\*", ".*"));
            td.add(pattern, txType);
        }
    }

    @Override
    public TransactionPropagationType getComponentMethodTxAttribute(ComponentMetadata component, String methodName) {
        TranData td = data.get(component);
        TransactionPropagationType result = null;
        if (td != null) {
            result = td.getAttribute(methodName);
        }
        if (result == null) {
            ComponentDefinitionRegistry cdr = this.getComponentDefinitionRegistry(component);
            if (cdr == null) {
                result = null;
            } else {
                List<BundleWideTxData> bundleData = bundleTransactionMap.get(cdr);
                result = BundleWideTxDataUtil.getAttribute(component.getId(), methodName, bundleData);
            }
        }
        LOGGER.debug("Component {}.{} is txType {}.", new Object[]{component.getId(), methodName, result});
        return result;
    }

    @Override
    public void populateBundleWideTransactionData(ComponentDefinitionRegistry cdr, TransactionPropagationType txType, String method, String bean) {
        LOGGER.debug("Setting bundle wide tx data for bean {}, method {} to {}", new Object[]{bean, method, txType});
        BundleWideTxData bundleWideTxData = new BundleWideTxData(txType, method, bean);
        List<BundleWideTxData> bundleData = bundleTransactionMap.get(cdr);
        if (bundleData == null) {
            bundleData = new ArrayList<BundleWideTxData>();
            bundleData.add(bundleWideTxData);
            bundleTransactionMap.put(cdr, bundleData);
        } else {
            bundleData.add(bundleWideTxData);
        }
    }

    private ComponentDefinitionRegistry getComponentDefinitionRegistry(ComponentMetadata metadata) {
        Enumeration<ComponentDefinitionRegistry> keys = bundleTransactionMap.keys();
        while (keys.hasMoreElements()) {
            ComponentDefinitionRegistry cdr = keys.nextElement();
            if (!cdr.containsComponentDefinition(metadata.getId()) || !metadata.equals(cdr.getComponentDefinition(metadata.getId()))) continue;
            return cdr;
        }
        return null;
    }

    private static class TranData {
        private final Map<Pattern, String> map = new ConcurrentHashMap<Pattern, String>();
        private final Map<String, String> cache = new ConcurrentHashMap<String, String>();

        public void add(Pattern pattern, TransactionPropagationType txAttribute) {
            this.map.put(pattern, txAttribute.name());
        }

        public TransactionPropagationType getAttribute(String name) {
            String txAttribute = this.cache.get(name);
            if (txAttribute != null) {
                return this.getType(txAttribute);
            }
            List<Pattern> matches = this.findMatches(name);
            int size = matches.size();
            if (size == 0) {
                return null;
            }
            if (size == 1) {
                txAttribute = this.map.get(matches.get(0));
            } else {
                size = (matches = this.selectPatternsWithFewestWildcards(matches)).size();
                if (size == 1) {
                    txAttribute = this.map.get(matches.get(0));
                } else {
                    size = (matches = this.selectLongestPatterns(matches)).size();
                    if (size == 1) {
                        txAttribute = this.map.get(matches.get(0));
                    } else {
                        throw new IllegalStateException(Constants.MESSAGES.getMessage("unable.to.apply.patterns", new Object[]{matches}));
                    }
                }
            }
            if (txAttribute != null) {
                this.cache.put(name, txAttribute);
            }
            return this.getType(txAttribute);
        }

        private TransactionPropagationType getType(String typeSt) {
            return typeSt == null || typeSt.length() == 0 ? null : TransactionPropagationType.valueOf(typeSt);
        }

        private List<Pattern> findMatches(String name) {
            ArrayList<Pattern> matches = new ArrayList<Pattern>();
            for (Pattern p : this.map.keySet()) {
                if (!p.matcher(name).matches()) continue;
                matches.add(p);
            }
            return matches;
        }

        private List<Pattern> selectPatternsWithFewestWildcards(List<Pattern> matches) {
            ArrayList<Pattern> remainingMatches = new ArrayList<Pattern>();
            int minWildcards = Integer.MAX_VALUE;
            for (Pattern p : matches) {
                String pattern = p.pattern();
                Matcher m = Constants.WILDCARD.matcher(pattern);
                int count = 0;
                while (m.find()) {
                    ++count;
                }
                if (count < minWildcards) {
                    remainingMatches.clear();
                    remainingMatches.add(p);
                    minWildcards = count;
                    continue;
                }
                if (count != minWildcards) continue;
                remainingMatches.add(p);
            }
            return remainingMatches;
        }

        private List<Pattern> selectLongestPatterns(List<Pattern> matches) {
            ArrayList<Pattern> remainingMatches = new ArrayList<Pattern>();
            int longestLength = 0;
            for (Pattern p : matches) {
                String pattern = p.pattern();
                int length = pattern.length();
                if (length > longestLength) {
                    remainingMatches.clear();
                    remainingMatches.add(p);
                    longestLength = length;
                    continue;
                }
                if (length != longestLength) continue;
                remainingMatches.add(p);
            }
            return remainingMatches;
        }
    }
}

