/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.langtagx;

import org.apache.jena.langtag.LangTag;
import org.apache.jena.langtag.LangTagException;
import org.apache.jena.langtag.LangTags;
import org.apache.jena.shared.JenaException;

public class LangTagX {
    static final boolean legacyLangTag = false;

    public static LangTag createLanguageTag(String langTagStr) {
        try {
            return LangTags.create(langTagStr);
        }
        catch (LangTagException ex) {
            throw LangTagX.convertException(ex);
        }
    }

    public static String formatLanguageTag(String langTagStr) {
        if (langTagStr == null) {
            return langTagStr;
        }
        if (langTagStr.isEmpty()) {
            return langTagStr;
        }
        try {
            return LangTags.format(langTagStr);
        }
        catch (LangTagException ex) {
            if (langTagStr.isBlank()) {
                throw new JenaException("Language tag string is all white space");
            }
            try {
                return LangTags.basicFormat(langTagStr);
            }
            catch (LangTagException ex2) {
                return langTagStr;
            }
        }
    }

    public static boolean checkLanguageTag(String langTagStr) {
        return LangTags.check(langTagStr);
    }

    public static boolean checkLanguageTagBasicSyntax(String langTagStr) {
        return LangTags.basicCheck(langTagStr);
    }

    public static void requireValidLanguageTag(String langTagStr) {
        try {
            LangTags.requireValid(langTagStr);
        }
        catch (LangTagException ex) {
            throw LangTagX.convertException(ex);
        }
    }

    public static boolean sameLanguageTagAs(String langTagStr1, String langTagStr2) {
        LangTagX.requireValidLanguageTag(langTagStr1);
        LangTagX.requireValidLanguageTag(langTagStr2);
        return langTagStr1.equalsIgnoreCase(langTagStr2);
    }

    private static JenaException convertException(LangTagException ex) {
        return new JenaException(ex.getMessage());
    }
}

