/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.demo.plugin;

import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.plugin.resourcethrottler.IResourceThrottler;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;

class WebHookBasedResourceThrottler
implements IResourceThrottler {
    private final AsyncLoadingCache<ResourceKey, Boolean> resultCache;
    private final HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).build();

    WebHookBasedResourceThrottler(URI webhookURI) {
        this.resultCache = Caffeine.newBuilder().expireAfterAccess(Duration.ofSeconds(60L)).refreshAfterWrite(Duration.ofSeconds(1L)).buildAsync((key, executor) -> {
            HttpRequest request = HttpRequest.newBuilder().uri(webhookURI).GET().timeout(Duration.ofSeconds(5L)).header("tenant_id", key.tenantId()).header("resource_type", key.type().name()).build();
            return ((CompletableFuture)this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 200) {
                    return Boolean.parseBoolean((String)response.body());
                }
                return true;
            })).exceptionally(e -> {
                System.out.println("Failed to call webhook: " + e.getMessage());
                return true;
            });
        });
    }

    public boolean hasResource(String tenantId, TenantResourceType type) {
        CompletableFuture<Boolean> resultFuture = this.resultCache.get(new ResourceKey(tenantId, type));
        if (resultFuture.isDone()) {
            try {
                return resultFuture.join();
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    private record ResourceKey(String tenantId, TenantResourceType type) {
    }
}

