/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basekv.raft.IRaftNode;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.RaftConfig;
import org.apache.bifromq.basekv.raft.RaftNodeState;
import org.apache.bifromq.basekv.raft.RaftNodeStateCandidate;
import org.apache.bifromq.basekv.raft.exception.ClusterConfigChangeException;
import org.apache.bifromq.basekv.raft.exception.DropProposalException;
import org.apache.bifromq.basekv.raft.exception.LeaderTransferException;
import org.apache.bifromq.basekv.raft.exception.ReadIndexException;
import org.apache.bifromq.basekv.raft.exception.RecoveryException;
import org.apache.bifromq.basekv.raft.exception.SnapshotException;
import org.apache.bifromq.basekv.raft.proto.AppendEntries;
import org.apache.bifromq.basekv.raft.proto.AppendEntriesReply;
import org.apache.bifromq.basekv.raft.proto.InstallSnapshot;
import org.apache.bifromq.basekv.raft.proto.InstallSnapshotReply;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.Propose;
import org.apache.bifromq.basekv.raft.proto.ProposeReply;
import org.apache.bifromq.basekv.raft.proto.RaftMessage;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;
import org.apache.bifromq.basekv.raft.proto.RequestReadIndex;
import org.apache.bifromq.basekv.raft.proto.RequestReadIndexReply;
import org.apache.bifromq.basekv.raft.proto.RequestVote;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.raft.proto.Voting;

class RaftNodeStateFollower
extends RaftNodeState {
    private final TreeMap<Long, StabilizingTask> stabilizingIndexes = new TreeMap(Long::compareTo);
    private final LinkedHashMap<Long, Set<Integer>> tickToReadRequestsMap;
    private final Map<Integer, CompletableFuture<Long>> idToReadRequestMap;
    private final LinkedHashMap<Long, Set<Integer>> tickToForwardedProposesMap;
    private final Map<Integer, CompletableFuture<Long>> idToForwardedProposeMap;
    private int randomElectionTimeoutTick;
    private long currentTick;
    private int electionElapsedTick;
    private String currentLeader;
    private InstallSnapshot currentISSRequest;
    private int forwardReqId = 0;

    RaftNodeStateFollower(long term, long commitIndex, String leader, RaftConfig config, IRaftStateStore stateStorage, IRaftNode.IRaftMessageSender sender, IRaftNode.IRaftEventListener listener, IRaftNode.ISnapshotInstaller installer, RaftNodeState.OnSnapshotInstalled onSnapshotInstalled, String ... tags) {
        this(term, commitIndex, leader, config, stateStorage, new LinkedHashMap<Long, RaftNodeState.ProposeTask>(), sender, listener, installer, onSnapshotInstalled, tags);
    }

    RaftNodeStateFollower(long term, long commitIndex, String leader, RaftConfig config, IRaftStateStore stateStorage, LinkedHashMap<Long, RaftNodeState.ProposeTask> uncommittedProposals, IRaftNode.IRaftMessageSender sender, IRaftNode.IRaftEventListener listener, IRaftNode.ISnapshotInstaller installer, RaftNodeState.OnSnapshotInstalled onSnapshotInstalled, String ... tags) {
        super(term, commitIndex, config, stateStorage, uncommittedProposals, sender, listener, installer, onSnapshotInstalled, tags);
        this.currentLeader = leader;
        this.randomElectionTimeoutTick = this.randomizeElectionTimeoutTick();
        this.tickToReadRequestsMap = new LinkedHashMap();
        this.idToReadRequestMap = new HashMap<Integer, CompletableFuture<Long>>();
        this.tickToForwardedProposesMap = new LinkedHashMap();
        this.idToForwardedProposeMap = new HashMap<Integer, CompletableFuture<Long>>();
    }

    @Override
    public RaftNodeStatus getState() {
        return RaftNodeStatus.Follower;
    }

    @Override
    public String currentLeader() {
        return this.currentLeader;
    }

    @Override
    RaftNodeState stepDown() {
        return this;
    }

    @Override
    void recover(CompletableFuture<Void> onDone) {
        onDone.completeExceptionally(RecoveryException.notLostQuorum());
    }

    @Override
    RaftNodeState tick() {
        Map.Entry<Long, Set<Integer>> entry;
        ++this.currentTick;
        ++this.electionElapsedTick;
        Iterator<Map.Entry<Long, Set<Integer>>> it = this.tickToReadRequestsMap.entrySet().iterator();
        while (it.hasNext() && (entry = it.next()).getKey() + 2L * (long)this.config.getHeartbeatTimeoutTick() < this.currentTick) {
            it.remove();
            entry.getValue().forEach(pendingReadId -> {
                CompletableFuture<Long> pendingOnDone = this.idToReadRequestMap.remove(pendingReadId);
                if (pendingOnDone != null && !pendingOnDone.isDone()) {
                    this.log.debug("Aborted forwarded timed-out ReadIndex request[{}]", pendingReadId);
                    pendingOnDone.completeExceptionally(ReadIndexException.forwardTimeout());
                }
            });
        }
        it = this.tickToForwardedProposesMap.entrySet().iterator();
        while (it.hasNext() && (entry = it.next()).getKey() + 2L * (long)this.config.getHeartbeatTimeoutTick() < this.currentTick) {
            it.remove();
            entry.getValue().forEach(pendingProposalId -> {
                CompletableFuture<Long> pendingOnDone = this.idToForwardedProposeMap.remove(pendingProposalId);
                if (pendingOnDone != null && !pendingOnDone.isDone()) {
                    this.log.debug("Aborted forwarded timed-out Propose request[{}]", pendingProposalId);
                    pendingOnDone.completeExceptionally(DropProposalException.forwardTimeout());
                }
            });
        }
        if (this.electionElapsedTick >= this.randomElectionTimeoutTick) {
            this.electionElapsedTick = 0;
            this.abortPendingReadIndexRequests(ReadIndexException.forwardTimeout());
            this.abortPendingProposeRequests(DropProposalException.forwardTimeout());
            if (this.currentISSRequest == null) {
                this.log.debug("Transit to candidate due to election timeout[{}]", (Object)this.randomElectionTimeoutTick);
                return new RaftNodeStateCandidate(this.currentTerm(), this.commitIndex, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags).campaign(this.config.isPreVote(), false);
            }
        }
        return this;
    }

    @Override
    void propose(ByteString fsmCmd, CompletableFuture<Long> onDone) {
        if (this.config.isDisableForwardProposal()) {
            this.log.debug("Forward proposal to leader is disabled");
            onDone.completeExceptionally(DropProposalException.leaderForwardDisabled());
            return;
        }
        if (this.currentLeader == null) {
            this.log.debug("Dropped proposal due to no leader elected in current term");
            onDone.completeExceptionally(DropProposalException.noLeader());
            return;
        }
        if (this.isProposeThrottled()) {
            this.log.debug("Dropped proposal due to log growing[uncommittedProposals:{}] exceeds threshold[maxUncommittedProposals:{}]", (Object)this.uncommittedProposals.size(), (Object)this.maxUncommittedProposals);
            onDone.completeExceptionally(DropProposalException.throttledByThreshold());
            return;
        }
        int forwardProposalId = this.nextForwardReqId();
        this.tickToForwardedProposesMap.compute(this.currentTick, (k, v) -> {
            if (v == null) {
                v = new HashSet<Integer>();
            }
            v.add(forwardProposalId);
            return v;
        });
        this.idToForwardedProposeMap.put(forwardProposalId, onDone);
        this.submitRaftMessages(this.currentLeader, RaftMessage.newBuilder().setTerm(this.currentTerm()).setPropose(Propose.newBuilder().setId(forwardProposalId).setCommand(fsmCmd).build()).build());
    }

    @Override
    RaftNodeState stableTo(long stabledIndex) {
        HashSet<Long> toRemove = new HashSet<Long>();
        for (Long index : this.stabilizingIndexes.keySet()) {
            if (index > stabledIndex) break;
            StabilizingTask task = this.stabilizingIndexes.get(index);
            while (task.pendingReplyCount-- > 0) {
                if (this.currentLeader == null) continue;
                this.log.trace("Entries below index[{}] stabilized, reply to leader[{}]", (Object)index, (Object)this.currentLeader);
                this.submitRaftMessages(this.currentLeader, RaftMessage.newBuilder().setTerm(this.currentTerm()).setAppendEntriesReply(AppendEntriesReply.newBuilder().setAccept(AppendEntriesReply.Accept.newBuilder().setLastIndex(index.longValue()).build()).setReadIndex(task.readIndex).build()).build());
            }
            if (task.committed) {
                this.commitIndex = index;
                this.log.trace("Advanced commitIndex[{}]", (Object)this.commitIndex);
                this.notifyCommit(false);
            }
            toRemove.add(index);
        }
        this.stabilizingIndexes.keySet().removeAll(toRemove);
        return this;
    }

    @Override
    void readIndex(CompletableFuture<Long> onDone) {
        if (this.currentLeader == null) {
            this.log.debug("Dropped ReadIndex forwarding due to no leader elected in current term");
            onDone.completeExceptionally(ReadIndexException.noLeader());
        } else {
            int forwardReadId = this.nextForwardReqId();
            this.tickToReadRequestsMap.compute(this.currentTick, (k, v) -> {
                if (v == null) {
                    v = new HashSet<Integer>();
                }
                v.add(forwardReadId);
                return v;
            });
            this.idToReadRequestMap.put(forwardReadId, onDone);
            this.submitRaftMessages(this.currentLeader, RaftMessage.newBuilder().setTerm(this.currentTerm()).setRequestReadIndex(RequestReadIndex.newBuilder().setId(forwardReadId).build()).build());
        }
    }

    @Override
    RaftNodeState receive(String fromPeer, RaftMessage message) {
        this.log.trace("Receive[{}] from {}", (Object)message, (Object)fromPeer);
        RaftNodeState nextState = this;
        if (message.getTerm() > this.currentTerm()) {
            switch (message.getMessageTypeCase()) {
                case REQUESTPREVOTE: {
                    if (!this.inLease()) {
                        this.handlePreVote(fromPeer, message.getTerm(), message.getRequestPreVote());
                    } else {
                        this.sendRequestPreVoteReply(fromPeer, message.getTerm(), false);
                    }
                    return nextState;
                }
                case REQUESTPREVOTEREPLY: {
                    return nextState;
                }
                case REQUESTVOTE: {
                    boolean leaderTransfer = message.getRequestVote().getLeaderTransfer();
                    if (leaderTransfer || !this.inLease() || this.voters().contains(fromPeer)) break;
                    this.log.debug("Vote[{}] from candidate[{}] not granted, lease is not expired", (Object)message.getTerm(), (Object)fromPeer);
                    this.sendRequestVoteReply(fromPeer, message.getTerm(), false);
                    return nextState;
                }
            }
            this.log.debug("Higher term[{}] message[{}] received from peer[{}]", new Object[]{message.getTerm(), message.getMessageTypeCase(), fromPeer});
            this.stateStorage.saveTerm(message.getTerm());
            this.currentLeader = null;
        } else if (message.getTerm() < this.currentTerm()) {
            this.handleLowTermMessage(fromPeer, message);
            return nextState;
        }
        switch (message.getMessageTypeCase()) {
            case APPENDENTRIES: {
                this.electionElapsedTick = 0;
                this.randomElectionTimeoutTick = this.randomizeElectionTimeoutTick();
                this.handleAppendEntries(fromPeer, message.getAppendEntries());
                break;
            }
            case INSTALLSNAPSHOT: {
                this.electionElapsedTick = 0;
                this.randomElectionTimeoutTick = this.randomizeElectionTimeoutTick();
                this.handleSnapshot(fromPeer, message.getInstallSnapshot());
                break;
            }
            case REQUESTPREVOTE: {
                this.sendRequestPreVoteReply(fromPeer, this.currentTerm(), false);
                break;
            }
            case REQUESTVOTE: {
                this.handleVote(fromPeer, message.getRequestVote());
                break;
            }
            case REQUESTREADINDEXREPLY: {
                this.handleRequestReadIndexReply(message.getRequestReadIndexReply());
                break;
            }
            case PROPOSEREPLY: {
                this.handleProposeReply(message.getProposeReply());
                break;
            }
            case TIMEOUTNOW: {
                nextState = this.handleTimeoutNow(fromPeer);
                break;
            }
        }
        return nextState;
    }

    @Override
    void transferLeadership(String newLeader, CompletableFuture<Void> onDone) {
        onDone.completeExceptionally(LeaderTransferException.notLeader());
    }

    @Override
    void changeClusterConfig(String correlateId, Set<String> newVoters, Set<String> newLearners, CompletableFuture<Void> onDone) {
        onDone.completeExceptionally(ClusterConfigChangeException.notLeader());
    }

    @Override
    void onSnapshotRestored(ByteString requested, ByteString installed, Throwable ex, CompletableFuture<Void> onDone) {
        if (this.currentISSRequest == null) {
            this.log.debug("Snapshot installation request not found");
            onDone.completeExceptionally(SnapshotException.noSnapshot());
            return;
        }
        InstallSnapshot iss = this.currentISSRequest;
        Snapshot snapshot = iss.getSnapshot();
        if (snapshot.getData() != requested) {
            if (ex != null) {
                this.log.debug("Obsolete snapshot install failed", ex);
                onDone.completeExceptionally(ex);
            } else {
                this.log.debug("Obsolete snapshot installation");
                onDone.completeExceptionally(SnapshotException.obsolete());
            }
            return;
        }
        this.currentISSRequest = null;
        if (ex != null) {
            this.log.warn("Snapshot[index:{},term:{}] rejected by FSM", new Object[]{snapshot.getIndex(), snapshot.getTerm(), ex});
            RaftMessage reply = RaftMessage.newBuilder().setTerm(this.currentTerm()).setInstallSnapshotReply(InstallSnapshotReply.newBuilder().setRejected(true).setLastIndex(snapshot.getIndex()).setReadIndex(iss.getReadIndex()).build()).build();
            this.submitRaftMessages(iss.getLeaderId(), reply);
            onDone.completeExceptionally(ex);
        } else {
            this.log.info("Snapshot[index:{},term:{}] accepted by FSM", (Object)snapshot.getIndex(), (Object)snapshot.getTerm());
            try {
                snapshot = snapshot.toBuilder().setData(installed).build();
                this.stateStorage.applySnapshot(snapshot);
                this.commitIndex = snapshot.getIndex();
                RaftMessage reply = RaftMessage.newBuilder().setTerm(this.currentTerm()).setInstallSnapshotReply(InstallSnapshotReply.newBuilder().setRejected(false).setLastIndex(snapshot.getIndex()).setReadIndex(iss.getReadIndex()).build()).build();
                this.notifySnapshotRestored();
                this.submitRaftMessages(iss.getLeaderId(), reply);
                onDone.complete(null);
            }
            catch (Throwable e) {
                this.log.error("Failed to apply snapshot[index:{}, term:{}]", new Object[]{snapshot.getIndex(), snapshot.getTerm(), e});
                RaftMessage reply = RaftMessage.newBuilder().setTerm(this.currentTerm()).setInstallSnapshotReply(InstallSnapshotReply.newBuilder().setRejected(true).setLastIndex(snapshot.getIndex()).setReadIndex(iss.getReadIndex()).build()).build();
                this.submitRaftMessages(iss.getLeaderId(), reply);
                onDone.completeExceptionally(e);
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.abortPendingReadIndexRequests(ReadIndexException.cancelled());
        this.abortPendingProposeRequests(DropProposalException.cancelled());
    }

    private void handleAppendEntries(String fromLeader, AppendEntries appendEntries) {
        if (!appendEntries.getLeaderId().equals(this.currentLeader)) {
            this.log.debug("Leader[{}] of current term[{}] elected", (Object)appendEntries.getLeaderId(), (Object)this.currentTerm());
            this.currentLeader = appendEntries.getLeaderId();
        }
        if (!this.entryMatch(appendEntries.getPrevLogIndex(), appendEntries.getPrevLogTerm())) {
            this.log.debug("Rejected {} entries from leader[{}] due to mismatched last entry[index:{},term:{}]", new Object[]{appendEntries.getEntriesCount(), fromLeader, appendEntries.getPrevLogIndex(), appendEntries.getPrevLogTerm()});
            Optional<LogEntry> lastEntry = this.stateStorage.entryAt(this.stateStorage.lastIndex());
            long lastEntryTerm = lastEntry.map(LogEntry::getTerm).orElseGet(() -> this.stateStorage.latestSnapshot().getTerm());
            this.submitRaftMessages(fromLeader, RaftMessage.newBuilder().setTerm(this.currentTerm()).setAppendEntriesReply(AppendEntriesReply.newBuilder().setReject(AppendEntriesReply.Reject.newBuilder().setLastIndex(this.stateStorage.lastIndex()).setTerm(lastEntryTerm).setRejectedIndex(appendEntries.getPrevLogIndex()).build()).setReadIndex(appendEntries.getReadIndex()).build()).build());
        } else {
            if (appendEntries.getEntriesCount() > 0) {
                long newLastIndex = appendEntries.getEntries(appendEntries.getEntriesCount() - 1).getIndex();
                this.log.debug("Append {} entries after entry[index:{},term:{}]", new Object[]{appendEntries.getEntriesCount(), appendEntries.getPrevLogIndex(), appendEntries.getPrevLogTerm()});
                this.stabilizingIndexes.compute(newLastIndex, (k, v) -> {
                    if (v == null) {
                        v = new StabilizingTask();
                    }
                    ++v.pendingReplyCount;
                    v.readIndex = appendEntries.getReadIndex();
                    return v;
                });
                this.stabilizingIndexes.tailMap(newLastIndex, false).clear();
                this.stateStorage.append(appendEntries.getEntriesList(), !this.config.isAsyncAppend());
            } else {
                this.submitRaftMessages(this.currentLeader, RaftMessage.newBuilder().setTerm(this.currentTerm()).setAppendEntriesReply(AppendEntriesReply.newBuilder().setAccept(AppendEntriesReply.Accept.newBuilder().setLastIndex(appendEntries.getPrevLogIndex()).build()).setReadIndex(appendEntries.getReadIndex()).build()).build());
            }
            long newCommitIndex = appendEntries.getCommitIndex();
            if (this.commitIndex < newCommitIndex) {
                if (this.stabilizingIndexes.isEmpty()) {
                    if (newCommitIndex <= this.stateStorage.lastIndex()) {
                        this.log.trace("Advanced commitIndex[from:{},to:{}]", (Object)this.commitIndex, (Object)newCommitIndex);
                        this.commitIndex = newCommitIndex;
                        this.notifyCommit(false);
                    } else {
                        this.log.debug("Committed entries[from:{},to:{}] missing locally", (Object)this.stateStorage.lastIndex(), (Object)newCommitIndex);
                        this.stabilizingIndexes.compute(this.stateStorage.lastIndex(), (k, v) -> {
                            if (v == null) {
                                v = new StabilizingTask();
                            }
                            v.committed = true;
                            return v;
                        });
                    }
                    return;
                }
                if (newCommitIndex < this.stabilizingIndexes.firstKey()) {
                    this.log.trace("Entries before index[{}] have stabilized, Advanced commitIndex[from:{},to:{}]", new Object[]{this.stabilizingIndexes.firstKey(), this.commitIndex, newCommitIndex});
                    this.commitIndex = newCommitIndex;
                    this.notifyCommit(false);
                } else {
                    if (newCommitIndex > this.stabilizingIndexes.lastKey()) {
                        this.log.debug("Committed Entries[from:{},to:{}] missing locally", (Object)this.stabilizingIndexes.lastKey(), (Object)newCommitIndex);
                    }
                    this.stabilizingIndexes.compute(this.stateStorage.lastIndex(), (k, v) -> {
                        if (v == null) {
                            v = new StabilizingTask();
                        }
                        v.committed = true;
                        return v;
                    });
                }
            }
        }
    }

    private void handleSnapshot(String fromLeader, InstallSnapshot installSnapshot) {
        Optional<LogEntry> committedEntry;
        if (!installSnapshot.getLeaderId().equals(this.currentLeader)) {
            this.log.debug("Leader[{}] of current term elected", (Object)installSnapshot.getLeaderId());
            this.currentLeader = installSnapshot.getLeaderId();
        }
        Snapshot snapshot = installSnapshot.getSnapshot();
        Snapshot latestSnapshot = this.stateStorage.latestSnapshot();
        long localIndex = latestSnapshot.getIndex();
        long localTerm = latestSnapshot.getTerm();
        if (this.commitIndex > localIndex && (committedEntry = this.stateStorage.entryAt(this.commitIndex)).isPresent()) {
            localIndex = this.commitIndex;
            localTerm = committedEntry.get().getTerm();
        }
        if (localTerm > snapshot.getTerm() || localTerm == snapshot.getTerm() && localIndex > snapshot.getIndex()) {
            this.log.debug("Ignore snapshot[index:{},term:{}] from peer[{}] since local committed progress[index:{},term:{}] is not behind", new Object[]{snapshot.getIndex(), snapshot.getTerm(), fromLeader, localIndex, localTerm});
            return;
        }
        if (this.currentISSRequest == null || this.isNewer(this.currentISSRequest.getSnapshot(), snapshot)) {
            this.currentISSRequest = installSnapshot;
            this.submitSnapshot(snapshot.getData(), this.currentLeader);
            this.log.debug("Snapshot[index:{},term:{}] from peer[{}] submitted to FSM", new Object[]{snapshot.getIndex(), snapshot.getTerm(), fromLeader});
        } else {
            this.log.debug("Ignore duplicated Snapshot[index:{},term:{}] from peer[{}]", new Object[]{snapshot.getIndex(), snapshot.getTerm(), fromLeader});
        }
    }

    private boolean isNewer(Snapshot existing, Snapshot newSnapshot) {
        return existing.getTerm() < newSnapshot.getTerm() || existing.getIndex() < newSnapshot.getIndex() && existing.getTerm() == newSnapshot.getTerm() || existing.getIndex() == newSnapshot.getIndex() && existing.getTerm() == newSnapshot.getTerm() && !existing.getData().equals((Object)newSnapshot.getData());
    }

    private void handleVote(String fromPeer, RequestVote request) {
        boolean vote;
        boolean canGrantVote = this.canGrantVote(request.getCandidateId(), request.getLeaderTransfer());
        boolean isLogUpToDate = this.isUpToDate(request.getLastLogTerm(), request.getLastLogIndex());
        boolean bl = vote = canGrantVote && isLogUpToDate;
        if (vote) {
            this.stateStorage.saveVoting(Voting.newBuilder().setTerm(this.currentTerm()).setFor(request.getCandidateId()).build());
            this.electionElapsedTick = 0;
        }
        this.log.debug("Vote for peer[{}] with last log[index={}, term={}]? {}, grant? {}, log up-to-date? {}", new Object[]{fromPeer, request.getLastLogIndex(), request.getLastLogTerm(), vote, canGrantVote, isLogUpToDate});
        this.sendRequestVoteReply(fromPeer, this.currentTerm(), vote);
    }

    private void handleRequestReadIndexReply(RequestReadIndexReply reply) {
        CompletableFuture<Long> pendingOnDone = this.idToReadRequestMap.get(reply.getId());
        if (pendingOnDone != null) {
            pendingOnDone.complete(reply.getReadIndex());
        }
    }

    private void handleProposeReply(ProposeReply reply) {
        CompletableFuture<Long> pendingOnDone = this.idToForwardedProposeMap.get(reply.getId());
        if (pendingOnDone != null) {
            switch (reply.getCode()) {
                case Success: {
                    pendingOnDone.complete(reply.getLogIndex());
                    break;
                }
                case DropByLeaderTransferring: {
                    pendingOnDone.completeExceptionally(DropProposalException.transferringLeader());
                    break;
                }
                case DropByMaxUnappliedEntries: {
                    pendingOnDone.completeExceptionally(DropProposalException.throttledByThreshold());
                    break;
                }
                case DropByNoLeader: {
                    pendingOnDone.completeExceptionally(DropProposalException.noLeader());
                    break;
                }
                case DropByForwardTimeout: {
                    pendingOnDone.completeExceptionally(DropProposalException.forwardTimeout());
                    break;
                }
                case DropByOverridden: {
                    pendingOnDone.completeExceptionally(DropProposalException.overridden());
                    break;
                }
                case DropBySupersededBySnapshot: {
                    pendingOnDone.completeExceptionally(DropProposalException.superseded());
                    break;
                }
                case DropByLeaderForwardDisabled: {
                    pendingOnDone.completeExceptionally(DropProposalException.leaderForwardDisabled());
                    break;
                }
                default: {
                    assert (reply.getCode() == ProposeReply.Code.DropByCancel);
                    pendingOnDone.completeExceptionally(DropProposalException.cancelled());
                }
            }
        }
    }

    private RaftNodeState handleTimeoutNow(String fromLeader) {
        if (this.promotable()) {
            this.log.info("Transited to candidate now by request from current leader[{}]", (Object)fromLeader);
            this.abortPendingReadIndexRequests(ReadIndexException.cancelled());
            this.abortPendingProposeRequests(DropProposalException.cancelled());
            return new RaftNodeStateCandidate(this.currentTerm(), this.commitIndex, this.config, this.stateStorage, this.uncommittedProposals, this.sender, this.listener, this.snapshotInstaller, this.onSnapshotInstalled, this.tags).campaign(this.config.isPreVote(), true);
        }
        return this;
    }

    private int nextForwardReqId() {
        this.forwardReqId = (this.forwardReqId + 1) % Integer.MAX_VALUE;
        return this.forwardReqId;
    }

    private boolean inLease() {
        return this.currentLeader != null && this.electionElapsedTick < this.config.getElectionTimeoutTick();
    }

    private boolean canGrantVote(String candidateId, boolean leaderTransfer) {
        Optional<Voting> vote = this.stateStorage.currentVoting();
        return vote.isPresent() && vote.get().getTerm() == this.currentTerm() && vote.get().getFor().equals(candidateId) || (this.currentLeader == null || leaderTransfer) && (vote.isEmpty() || vote.get().getTerm() < this.currentTerm());
    }

    private void abortPendingReadIndexRequests(ReadIndexException e) {
        Iterator<Map.Entry<Long, Set<Integer>>> it = this.tickToReadRequestsMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Set<Integer>> entry = it.next();
            it.remove();
            entry.getValue().forEach(pendingReadId -> {
                CompletableFuture<Long> pendingOnDone = this.idToReadRequestMap.remove(pendingReadId);
                if (pendingOnDone != null && !pendingOnDone.isDone()) {
                    pendingOnDone.completeExceptionally(e);
                }
            });
        }
    }

    private void abortPendingProposeRequests(DropProposalException e) {
        Iterator<Map.Entry<Long, Set<Integer>>> it = this.tickToForwardedProposesMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Set<Integer>> entry = it.next();
            it.remove();
            entry.getValue().forEach(pendingProposalId -> {
                CompletableFuture<Long> pendingOnDone = this.idToForwardedProposeMap.remove(pendingProposalId);
                if (pendingOnDone != null && !pendingOnDone.isDone()) {
                    pendingOnDone.completeExceptionally(e);
                }
            });
        }
    }

    private boolean entryMatch(long index, long term) {
        Optional<LogEntry> entry = this.stateStorage.entryAt(index);
        if (entry.isPresent()) {
            return entry.get().getTerm() == term;
        }
        Snapshot snapshot = this.stateStorage.latestSnapshot();
        return snapshot.getIndex() == index && snapshot.getTerm() == term;
    }

    private static class StabilizingTask {
        int pendingReplyCount = 0;
        long readIndex = -1L;
        boolean committed = false;

        private StabilizingTask() {
        }
    }
}

