/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.server;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.raft.exception.ReadIndexException;
import org.apache.bifromq.basekv.store.IKVRangeStore;
import org.apache.bifromq.basekv.store.exception.KVRangeException;
import org.apache.bifromq.basekv.store.exception.KVRangeStoreException;
import org.apache.bifromq.basekv.store.proto.KVRangeROReply;
import org.apache.bifromq.basekv.store.proto.KVRangeRORequest;
import org.apache.bifromq.basekv.store.proto.NullableValue;
import org.apache.bifromq.basekv.store.proto.ReplyCode;
import org.apache.bifromq.baserpc.server.ResponsePipeline;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class QueryPipeline
extends ResponsePipeline<KVRangeRORequest, KVRangeROReply> {
    private final Logger log;
    private final ConcurrentLinkedQueue<QueryTask> requests = new ConcurrentLinkedQueue();
    private final IKVRangeStore kvRangeStore;
    private final boolean linearized;
    private final AtomicBoolean executing = new AtomicBoolean(false);

    public QueryPipeline(IKVRangeStore kvRangeStore, boolean linearized, StreamObserver<KVRangeROReply> responseObserver) {
        super(responseObserver);
        this.linearized = linearized;
        this.kvRangeStore = kvRangeStore;
        this.log = MDCLogger.getLogger(QueryPipeline.class, (String[])new String[]{"clusterId", kvRangeStore.clusterId(), "storeId", kvRangeStore.id()});
    }

    protected CompletableFuture<KVRangeROReply> handleRequest(String ignore, KVRangeRORequest request) {
        QueryTask task = switch (request.getTypeCase()) {
            case KVRangeRORequest.TypeCase.GETKEY -> new QueryTask(request, this::get);
            case KVRangeRORequest.TypeCase.EXISTKEY -> new QueryTask(request, this::exist);
            default -> new QueryTask(request, this::roCoproc);
        };
        this.log.trace("Submit ro request:\n{}", (Object)request);
        this.requests.add(task);
        this.submitForExecution();
        return task.onDone;
    }

    private void submitForExecution() {
        if (this.executing.compareAndSet(false, true)) {
            QueryTask task = this.requests.poll();
            if (task != null) {
                KVRangeRORequest request = task.request;
                if (task.onDone.isCancelled() || this.isClosed()) {
                    this.log.trace("Skip ro range request due to canceled or closed pipeline [linearized={}]:\n{}", (Object)this.linearized, (Object)request);
                    this.executing.set(false);
                    if (!this.requests.isEmpty()) {
                        this.submitForExecution();
                    }
                    return;
                }
                task.queryFn.apply(request).exceptionally(CompletableFutureUtil.unwrap(e -> {
                    if (e instanceof KVRangeException.BadVersion) {
                        KVRangeException.BadVersion badVersion = (KVRangeException.BadVersion)e;
                        KVRangeROReply.Builder replyBuilder = KVRangeROReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.BadVersion);
                        if (badVersion.latest != null) {
                            replyBuilder.setLatest(badVersion.latest);
                        }
                        return replyBuilder.build();
                    }
                    if (e instanceof KVRangeException.TryLater) {
                        KVRangeException.TryLater tryLater = (KVRangeException.TryLater)e;
                        KVRangeROReply.Builder replyBuilder = KVRangeROReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater);
                        if (tryLater.latest != null) {
                            replyBuilder.setLatest(tryLater.latest);
                        }
                        return replyBuilder.build();
                    }
                    if (e instanceof KVRangeStoreException.KVRangeNotFoundException) {
                        return KVRangeROReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater).build();
                    }
                    if (e instanceof KVRangeException.BadRequest) {
                        KVRangeException.BadRequest badRequest = (KVRangeException.BadRequest)e;
                        KVRangeROReply.Builder replyBuilder = KVRangeROReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.BadRequest);
                        if (badRequest.latest != null) {
                            replyBuilder.setLatest(badRequest.latest);
                        }
                        return replyBuilder.build();
                    }
                    if (e instanceof ReadIndexException) {
                        return KVRangeROReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.TryLater).build();
                    }
                    this.log.debug("query range error: reqId={}", (Object)request.getReqId(), e);
                    return KVRangeROReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.InternalError).build();
                })).thenAccept(v -> {
                    if (!task.onDone.isDone()) {
                        task.onDone.complete((KVRangeROReply)v);
                    }
                    this.executing.set(false);
                    if (!this.requests.isEmpty()) {
                        this.submitForExecution();
                    }
                });
            } else {
                this.executing.set(false);
                if (!this.requests.isEmpty()) {
                    this.submitForExecution();
                }
            }
        }
    }

    private CompletionStage<KVRangeROReply> exist(KVRangeRORequest request) {
        return this.kvRangeStore.exist(request.getVer(), request.getKvRangeId(), request.getExistKey(), this.linearized).thenApply(result -> KVRangeROReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).setExistResult(result.booleanValue()).build());
    }

    private CompletionStage<KVRangeROReply> get(KVRangeRORequest request) {
        return this.kvRangeStore.get(request.getVer(), request.getKvRangeId(), request.getGetKey(), this.linearized).thenApply(result -> KVRangeROReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).setGetResult(result.map(v -> NullableValue.newBuilder().setValue(v).build()).orElse(NullableValue.getDefaultInstance())).build());
    }

    private CompletionStage<KVRangeROReply> roCoproc(KVRangeRORequest request) {
        return this.kvRangeStore.queryCoProc(request.getVer(), request.getKvRangeId(), request.getRoCoProc(), this.linearized).thenApply(result -> KVRangeROReply.newBuilder().setReqId(request.getReqId()).setCode(ReplyCode.Ok).setRoCoProcResult(result).build());
    }

    protected void afterClose() {
        this.requests.clear();
    }

    private static class QueryTask {
        final KVRangeRORequest request;
        final Function<KVRangeRORequest, CompletionStage<KVRangeROReply>> queryFn;
        final CompletableFuture<KVRangeROReply> onDone = new CompletableFuture();

        QueryTask(KVRangeRORequest request, Function<KVRangeRORequest, CompletionStage<KVRangeROReply>> queryFn) {
            this.request = request;
            this.queryFn = queryFn;
        }
    }
}

