/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import java.io.Serializable;
import java.math.RoundingMode;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberCheckPolicy;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberCheckPolicy$Lax$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberCheckPolicy$Strict$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRounding;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRounding$Explicit$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRounding$Pattern$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRoundingMode;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRoundingMode$RoundCeiling$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRoundingMode$RoundDown$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRoundingMode$RoundFloor$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRoundingMode$RoundHalfDown$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRoundingMode$RoundHalfEven$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRoundingMode$RoundHalfUp$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRoundingMode$RoundUnnecessary$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextNumberRoundingMode$RoundUp$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.MaybeChar$;
import org.apache.daffodil.lib.util.MaybeDouble$;
import org.apache.daffodil.lib.util.MaybeInt$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dsom.DPathCompileInfo;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.Evaluatable$;
import org.apache.daffodil.runtime1.processors.InfosetCachedEvaluatable;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import org.apache.daffodil.runtime1.processors.TextStandardDecimalSeparatorEv;
import org.apache.daffodil.runtime1.processors.TextStandardExponentRepEv;
import org.apache.daffodil.runtime1.processors.TextStandardGroupingSeparatorEv;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class TextNumberFormatEv
extends Evaluatable<DecimalFormat>
implements InfosetCachedEvaluatable<DecimalFormat> {
    private final DPathCompileInfo tci;
    private final Object decimalSepEv;
    private final Object groupingSepEv;
    private final Object exponentRepEv;
    private final Object infRep;
    private final Object nanRep;
    private final TextNumberCheckPolicy checkPolicy;
    private final String textNumberPattern;
    private final TextNumberRounding rounding;
    private final Object roundingMode;
    private final long roundingIncrement;
    private final List<String> zeroRepsRaw;
    private final long icuPadPosition;

    public TextNumberFormatEv(DPathCompileInfo tci, Object decimalSepEv, Object groupingSepEv, Object exponentRepEv, Object infRep, Object nanRep, TextNumberCheckPolicy checkPolicy, String textNumberPattern, TextNumberRounding rounding, Object roundingMode, long roundingIncrement, List<String> zeroRepsRaw, long icuPadPosition, NodeInfo.PrimType primType) {
        this.tci = tci;
        this.decimalSepEv = decimalSepEv;
        this.groupingSepEv = groupingSepEv;
        this.exponentRepEv = exponentRepEv;
        this.infRep = infRep;
        this.nanRep = nanRep;
        this.checkPolicy = checkPolicy;
        this.textNumberPattern = textNumberPattern;
        this.rounding = rounding;
        this.roundingMode = roundingMode;
        this.roundingIncrement = roundingIncrement;
        this.zeroRepsRaw = zeroRepsRaw;
        this.icuPadPosition = icuPadPosition;
        super(tci, Evaluatable$.MODULE$.$lessinit$greater$default$2());
    }

    @Override
    public Seq<Evaluatable<Object>> runtimeDependencies() {
        return ((IterableOnceOps)((IterableOps)Maybe$.MODULE$.toList$extension(this.decimalSepEv).$plus$plus(Maybe$.MODULE$.toList$extension(this.groupingSepEv))).$plus$plus(Maybe$.MODULE$.toList$extension(this.exponentRepEv))).toVector();
    }

    private void checkUnique(int decimalSep, int groupingSep, Object exponentRep) {
        Iterable bindings = (Iterable)((IterableOps)((IterableOps)((IterableOps)((IterableOps)Option$.MODULE$.option2Iterable(MaybeChar$.MODULE$.toOption$extension(decimalSep).map((Function1 & Serializable)v -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)v)).toString(), (Object)"textStandardDecimalSeparator"))).$plus$plus((IterableOnce)MaybeChar$.MODULE$.toOption$extension(groupingSep).map((Function1 & Serializable)v -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)v)).toString(), (Object)"textStandardGroupingSeparator")))).$plus$plus((IterableOnce)Maybe$.MODULE$.toOption$extension(exponentRep).map((Function1 & Serializable)v -> Tuple2$.MODULE$.apply(v, (Object)"textStandardExponentRep")))).$plus$plus((IterableOnce)Maybe$.MODULE$.toOption$extension(this.infRep).map((Function1 & Serializable)v -> Tuple2$.MODULE$.apply(v, (Object)"textStandardInfinityRep")))).$plus$plus((IterableOnce)Maybe$.MODULE$.toOption$extension(this.nanRep).map((Function1 & Serializable)v -> Tuple2$.MODULE$.apply(v, (Object)"textStandardNaNRep")))).$plus$plus((IterableOnce)this.zeroRepsRaw.map((Function1 & Serializable)zr -> Tuple2$.MODULE$.apply(zr, (Object)"textStandardZeroRep")));
        Map mm = bindings.groupBy((Function1 & Serializable)_$1 -> (String)_$1._1()).view().mapValues((Function1 & Serializable)t -> (Iterable)t.map((Function1 & Serializable)_$2 -> (String)_$2._2())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Map dupes = (Map)mm.filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Iterable s = (Iterable)tuple2._2();
                return s.size() > 1;
            }
            throw new MatchError((Object)tuple2);
        });
        scala.collection.immutable.Iterable dupeStrings = (scala.collection.immutable.Iterable)dupes.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Iterable s = (Iterable)tuple2._2();
                return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Non-distinct property '%s' found in: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{k, s.mkString(", ")}));
            }
            throw new MatchError((Object)tuple2);
        });
        DPathCompileInfo SDEUsingMacrosMixin_this = this.tci;
        boolean testThatWillThrowIfFalse$proxy1 = dupeStrings.isEmpty();
        if (!testThatWillThrowIfFalse$proxy1) {
            throw SDEUsingMacrosMixin_this.SDE(dupeStrings.mkString("\n"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
    }

    private DecimalFormat generateNumFormat(int decimalSep, int groupingSep, Object exponentRep) {
        boolean bl;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        if (MaybeChar$.MODULE$.isDefined$extension(decimalSep)) {
            dfs.setDecimalSeparator(MaybeChar$.MODULE$.get$extension(decimalSep));
        }
        if (MaybeChar$.MODULE$.isDefined$extension(groupingSep)) {
            dfs.setGroupingSeparator(MaybeChar$.MODULE$.get$extension(groupingSep));
        }
        if (Maybe$.MODULE$.isDefined$extension(exponentRep)) {
            dfs.setExponentSeparator((String)Maybe$.MODULE$.get$extension(exponentRep));
        }
        if (Maybe$.MODULE$.isDefined$extension(this.infRep)) {
            dfs.setInfinity((String)Maybe$.MODULE$.get$extension(this.infRep));
        }
        if (Maybe$.MODULE$.isDefined$extension(this.nanRep)) {
            dfs.setNaN((String)Maybe$.MODULE$.get$extension(this.nanRep));
        }
        DecimalFormat df = new DecimalFormat(this.textNumberPattern, dfs);
        TextNumberCheckPolicy textNumberCheckPolicy = this.checkPolicy;
        if (TextNumberCheckPolicy$Strict$.MODULE$.equals(textNumberCheckPolicy)) {
            bl = true;
        } else if (TextNumberCheckPolicy$Lax$.MODULE$.equals(textNumberCheckPolicy)) {
            bl = false;
        } else {
            throw new MatchError((Object)textNumberCheckPolicy);
        }
        boolean cp = bl;
        df.setParseStrict(cp);
        df.setDecimalPatternMatchRequired(cp);
        TextNumberRounding textNumberRounding = this.rounding;
        if (TextNumberRounding$Pattern$.MODULE$.equals(textNumberRounding)) {
            df.setRoundingMode(RoundingMode.HALF_EVEN.ordinal());
        } else if (TextNumberRounding$Explicit$.MODULE$.equals(textNumberRounding)) {
            RoundingMode roundingMode;
            TextNumberRoundingMode textNumberRoundingMode = (TextNumberRoundingMode)Maybe$.MODULE$.get$extension(this.roundingMode);
            if (TextNumberRoundingMode$RoundCeiling$.MODULE$.equals(textNumberRoundingMode)) {
                roundingMode = RoundingMode.CEILING;
            } else if (TextNumberRoundingMode$RoundFloor$.MODULE$.equals(textNumberRoundingMode)) {
                roundingMode = RoundingMode.FLOOR;
            } else if (TextNumberRoundingMode$RoundDown$.MODULE$.equals(textNumberRoundingMode)) {
                roundingMode = RoundingMode.DOWN;
            } else if (TextNumberRoundingMode$RoundUp$.MODULE$.equals(textNumberRoundingMode)) {
                roundingMode = RoundingMode.UP;
            } else if (TextNumberRoundingMode$RoundHalfEven$.MODULE$.equals(textNumberRoundingMode)) {
                roundingMode = RoundingMode.HALF_EVEN;
            } else if (TextNumberRoundingMode$RoundHalfDown$.MODULE$.equals(textNumberRoundingMode)) {
                roundingMode = RoundingMode.HALF_DOWN;
            } else if (TextNumberRoundingMode$RoundHalfUp$.MODULE$.equals(textNumberRoundingMode)) {
                roundingMode = RoundingMode.HALF_UP;
            } else if (TextNumberRoundingMode$RoundUnnecessary$.MODULE$.equals(textNumberRoundingMode)) {
                roundingMode = RoundingMode.UNNECESSARY;
            } else {
                throw new MatchError((Object)textNumberRoundingMode);
            }
            RoundingMode rm = roundingMode;
            df.setRoundingMode(rm.ordinal());
            df.setRoundingIncrement(MaybeDouble$.MODULE$.get$extension(this.roundingIncrement));
        } else {
            throw new MatchError((Object)textNumberRounding);
        }
        if (MaybeInt$.MODULE$.isDefined$extension(this.icuPadPosition)) {
            df.setPadPosition(MaybeInt$.MODULE$.get$extension(this.icuPadPosition));
        }
        return df;
    }

    @Override
    public DecimalFormat compute(ParseOrUnparseState state) {
        int n;
        if (Maybe$.MODULE$.isDefined$extension(this.decimalSepEv)) {
            List seps = (List)((TextStandardDecimalSeparatorEv)Maybe$.MODULE$.get$extension(this.decimalSepEv)).evaluate(state);
            if (seps.length() > 1) {
                throw this.tci.SDE("More than one textStandardDecimalSeparator '%s'. Only a single one is supported.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{seps.mkString(" ")}));
            }
            n = MaybeChar$.MODULE$.apply(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString((String)seps.head()), 0));
        } else {
            n = MaybeChar$.MODULE$.Nope();
        }
        int decimalSepList = n;
        int groupingSep = Maybe$.MODULE$.isDefined$extension(this.groupingSepEv) ? MaybeChar$.MODULE$.apply(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString((String)((TextStandardGroupingSeparatorEv)Maybe$.MODULE$.get$extension(this.groupingSepEv)).evaluate(state)), 0)) : MaybeChar$.MODULE$.Nope();
        Object exponentRep = Maybe$.MODULE$.isDefined$extension(this.exponentRepEv) ? Maybe$One$.MODULE$.apply(((TextStandardExponentRepEv)Maybe$.MODULE$.get$extension(this.exponentRepEv)).evaluate(state)) : Maybe$.MODULE$.Nope();
        this.checkUnique(decimalSepList, groupingSep, exponentRep);
        DecimalFormat numFormat = this.generateNumFormat(decimalSepList, groupingSep, exponentRep);
        return numFormat;
    }
}

