/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;

public class CaseInsensitiveStringMatchPredicate
implements Predicate<CharSequence> {
    @Nonnull
    private final String target;

    public CaseInsensitiveStringMatchPredicate(@Nonnull String matchString) {
        this.target = Constraint.isNotNull(matchString, "Target string cannot be null");
    }

    @Override
    public boolean test(@Nullable CharSequence input) {
        if (input == null) {
            return false;
        }
        return this.target.equalsIgnoreCase(input.toString());
    }
}

