/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.event;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.component.event.EventEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;

public class EventComponent
extends UriEndpointComponent
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(EventComponent.class);
    private ApplicationContext applicationContext;
    private final Set<EventEndpoint> endpoints = new LinkedHashSet<EventEndpoint>();

    public EventComponent() {
        super(EventEndpoint.class);
    }

    public EventComponent(ApplicationContext applicationContext) {
        super(EventEndpoint.class);
        this.setApplicationContext(applicationContext);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public ConfigurableApplicationContext getConfigurableApplicationContext() {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext instanceof ConfigurableApplicationContext) {
            return (ConfigurableApplicationContext)applicationContext;
        }
        throw new IllegalArgumentException("Class: " + applicationContext.getClass().getName() + " is not an instanceof ConfigurableApplicationContext.");
    }

    protected EventEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        EventEndpoint answer = new EventEndpoint(uri, this, remaining);
        this.setProperties((Object)answer, parameters);
        return answer;
    }

    protected void consumerStarted(EventEndpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    protected void consumerStopped(EventEndpoint endpoint) {
        this.endpoints.remove((Object)endpoint);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        for (EventEndpoint endpoint : this.endpoints) {
            try {
                endpoint.onApplicationEvent(event);
            }
            catch (Exception e) {
                LOG.warn("Error on application event " + event + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    protected void doStop() throws Exception {
        this.endpoints.clear();
        super.doStop();
    }
}

