/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.RequestInterceptor;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CrossTenancyRequestClientFilter
implements RequestInterceptor {
    public static final int PRIORITY = 999;
    private final String authorizedTenancyIdsValue;

    public CrossTenancyRequestClientFilter(String[] authorizedTenancyIds) {
        if (authorizedTenancyIds == null || authorizedTenancyIds.length == 0) {
            throw new IllegalArgumentException("Must provide at least one authorized tenancyId");
        }
        for (String authorizedTenancyId : authorizedTenancyIds) {
            if (authorizedTenancyId != null && !authorizedTenancyId.isEmpty()) continue;
            throw new IllegalArgumentException("Authorized tenancyId was not valid");
        }
        this.authorizedTenancyIdsValue = Arrays.asList(authorizedTenancyIds).stream().collect(Collectors.joining(","));
    }

    public void intercept(HttpRequest request) {
        request.header("x-cross-tenancy-request", this.authorizedTenancyIdsValue);
    }
}

