/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.product.dependencies;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.helper.Dependency;
import org.netbeans.installer.utils.helper.Version;

public class Requirement
extends Dependency {
    public static final String NAME = "requirement";
    private List<List<Requirement>> alternatives;

    public Requirement(String uid, Version versionLower, Version versionUpper, Version versionResolved) {
        this(uid, versionLower, versionUpper, versionResolved, new ArrayList<List<Requirement>>());
    }

    public Requirement(String uid, Version versionLower, Version versionUpper, Version versionResolved, List<List<Requirement>> altRequirements) {
        super(uid, versionLower, versionUpper, versionResolved);
        this.alternatives = new ArrayList<List<Requirement>>(altRequirements);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean satisfies(Product product) {
        if (this.getVersionResolved() != null) {
            return product.getUid().equals(this.getUid()) && product.getVersion().equals(this.getVersionResolved());
        }
        return product.getUid().equals(this.getUid()) && product.getVersion().newerOrEquals(this.getVersionLower()) && product.getVersion().olderOrEquals(this.getVersionUpper());
    }

    public List<List<Requirement>> getAlternatives() {
        return this.alternatives;
    }
}

