/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import org.netbeans.modules.print.util.Macro;
import org.netbeans.modules.print.util.UI;
import org.openide.util.NbPreferences;

public final class Config {
    private PageFormat myPageFormat;
    private static final Config DEFAULT = new Config();
    private static final double INCH = 72.0;
    private static final Font DEFAULT_TITLE_FONT = new Font("Serif", 0, 10);
    private static final Font DEFAULT_TEXT_FONT = new Font("Monospaced", 0, 10);
    private static final Color DEFAULT_BACGROUND_COLOR = new Color(255, 250, 255);
    private static final String COMMA = ",";
    private static final String EMPTY = "";
    private static final String HEADER_LEFT_TEXT = Macro.NAME.getName();
    private static final String HEADER_CENTER_TEXT = "";
    private static final String HEADER_RIGHT_TEXT = "";
    private static final String FOOTER_LEFT_TEXT = Config.getPageOfCount(Config.getRowColumn(Macro.ROW.getName(), Macro.COLUMN.getName()), Macro.COUNT.getName());
    private static final String FOOTER_CENTER_TEXT = "";
    private static final String FOOTER_RIGHT_TEXT = Macro.MODIFIED_DATE.getName() + "  " + Macro.MODIFIED_TIME.getName();
    private static final String SELECTION = "print.text.selection";
    private static final String AS_EDITOR = "print.text.as.editor";
    private static final String WRAP_LINES = "print.text.wrap.lines";
    private static final String LINE_NUMBERS = "print.text.line.numbers";
    private static final String USE_FONT = "print.text.use.font";
    private static final String USE_COLOR = "print.text.use.color";
    private static final String TEXT_COLOR = "print.text.color";
    private static final String TEXT_FONT = "print.text.font";
    private static final String LINE_SPACING = "print.text.line.spacing";
    private static final String BACKGROUND_COLOR = "print.text.background.color";
    private static final String ZOOM = "print.zoom";
    private static final String BORDER = "print.border";
    private static final String BORDER_COLOR = "print.border.color";
    private static final String HEADER = "print.header";
    private static final String HEADER_LEFT = "print.header.left";
    private static final String HEADER_CENTER = "print.header.center";
    private static final String HEADER_RIGHT = "print.header.right";
    private static final String HEADER_COLOR = "print.header.color";
    private static final String HEADER_FONT = "print.header.font";
    private static final String FOOTER = "print.footer";
    private static final String FOOTER_LEFT = "print.footer.left";
    private static final String FOOTER_CENTER = "print.footer.center";
    private static final String FOOTER_RIGHT = "print.footer.right";
    private static final String FOOTER_COLOR = "print.footer.color";
    private static final String FOOTER_FONT = "print.footer.font";
    private static final String PAGE_ORIENTATION = "print.page.orientation";
    private static final String PAPER_WIDTH = "print.paper.width";
    private static final String PAPER_HEIGHT = "print.paper.height";
    private static final String AREA_X = "print.area.x";
    private static final String AREA_Y = "print.area.y";
    private static final String AREA_WIDTH = "print.area.width";
    private static final String AREA_HEIGHT = "print.area.height";
    public static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, true, true);

    private Config() {
    }

    public boolean showPageSetup() {
        PageFormat pageFormat;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat2 = this.getPageFormat();
        if (pageFormat2 == (pageFormat = printerJob.pageDialog(pageFormat2))) {
            return false;
        }
        this.myPageFormat = pageFormat;
        this.set(PAGE_ORIENTATION, this.myPageFormat.getOrientation());
        Paper paper = this.myPageFormat.getPaper();
        this.set(PAPER_WIDTH, paper.getWidth());
        this.set(PAPER_HEIGHT, paper.getHeight());
        this.set(AREA_X, paper.getImageableX());
        this.set(AREA_Y, paper.getImageableY());
        this.set(AREA_WIDTH, paper.getImageableWidth());
        this.set(AREA_HEIGHT, paper.getImageableHeight());
        return true;
    }

    public PageFormat getPageFormat() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (this.myPageFormat == null) {
            this.myPageFormat = printerJob.defaultPage();
            this.myPageFormat.setOrientation(UI.round(this.get(PAGE_ORIENTATION, 1.0)));
            Paper paper = this.myPageFormat.getPaper();
            if (this.get(PAPER_WIDTH, null) != null && this.get(PAPER_HEIGHT, null) != null) {
                paper.setSize(this.get(PAPER_WIDTH, 72.0), this.get(PAPER_HEIGHT, 72.0));
            }
            if (this.get(AREA_X, null) != null && this.get(AREA_Y, null) != null && this.get(AREA_WIDTH, null) != null && this.get(AREA_HEIGHT, null) != null) {
                paper.setImageableArea(this.get(AREA_X, 72.0), this.get(AREA_Y, 72.0), this.get(AREA_WIDTH, 72.0), this.get(AREA_HEIGHT, 72.0));
            }
            this.myPageFormat.setPaper(paper);
        }
        return this.myPageFormat;
    }

    public int getPaperWidth() {
        return (int)Math.floor(this.getPageFormat().getWidth());
    }

    public int getPaperHeight() {
        return (int)Math.floor(this.getPageFormat().getHeight());
    }

    public int getPageX() {
        return UI.round(this.getPageFormat().getImageableX());
    }

    public int getPageY() {
        int n = UI.round(this.getPageFormat().getImageableY());
        if (this.hasHeader()) {
            n = (int)((double)n + this.getBound(this.getHeaderFont()).getHeight());
        }
        return n;
    }

    public int getPageWidth() {
        return (int)Math.floor(this.getPageFormat().getImageableWidth());
    }

    public int getPageHeight() {
        int n = (int)Math.floor(this.getPageFormat().getImageableHeight());
        if (this.hasHeader()) {
            n = (int)((double)n - this.getBound(this.getHeaderFont()).getHeight());
        }
        if (this.hasFooter()) {
            n = (int)((double)n - this.getBound(this.getFooterFont()).getHeight());
        }
        return n;
    }

    public int getHeaderY() {
        return this.getPageY() - UI.round(this.getBound(this.getHeaderFont()).getMaxY());
    }

    public int getFooterY() {
        return this.getPageY() + this.getPageHeight() + UI.round(this.getBound(this.getFooterFont()).getHeight() - this.getBound(this.getFooterFont()).getMaxY());
    }

    public boolean hasBorder() {
        return this.get(BORDER, true);
    }

    public void setBorder(boolean bl) {
        this.set(BORDER, bl);
    }

    public boolean isSelection() {
        return this.get(SELECTION, false);
    }

    public void setSelection(boolean bl) {
        this.set(SELECTION, bl);
    }

    public boolean isAsEditor() {
        return this.get(AS_EDITOR, false);
    }

    public void setAsEditor(boolean bl) {
        this.set(AS_EDITOR, bl);
    }

    public Color getBorderColor() {
        return this.getColor(this.get(BORDER_COLOR, null), Color.black);
    }

    public void setBorderColor(Color color) {
        this.set(BORDER_COLOR, this.getString(color));
    }

    public boolean hasHeader() {
        return this.get(HEADER, true);
    }

    public void setHeader(boolean bl) {
        this.set(HEADER, bl);
    }

    public String getHeaderLeft() {
        return this.get(HEADER_LEFT, HEADER_LEFT_TEXT);
    }

    public String getHeaderCenter() {
        return this.get(HEADER_CENTER, "");
    }

    public String getHeaderRight() {
        return this.get(HEADER_RIGHT, "");
    }

    public void setHeaderLeft(String string) {
        this.set(HEADER_LEFT, string);
    }

    public void setHeaderCenter(String string) {
        this.set(HEADER_CENTER, string);
    }

    public void setHeaderRight(String string) {
        this.set(HEADER_RIGHT, string);
    }

    public Color getHeaderColor() {
        return this.getColor(this.get(HEADER_COLOR, null), Color.black);
    }

    public Font getHeaderFont() {
        return this.getFont(this.get(HEADER_FONT, null), DEFAULT_TITLE_FONT);
    }

    public void setHeaderColor(Color color) {
        this.set(HEADER_COLOR, this.getString(color));
    }

    public void setHeaderFont(Font font) {
        this.set(HEADER_FONT, this.getString(font));
    }

    public boolean hasFooter() {
        return this.get(FOOTER, true);
    }

    public void setFooter(boolean bl) {
        this.set(FOOTER, bl);
    }

    public String getFooterLeft() {
        return this.get(FOOTER_LEFT, FOOTER_LEFT_TEXT);
    }

    public String getFooterCenter() {
        return this.get(FOOTER_CENTER, "");
    }

    public String getFooterRight() {
        return this.get(FOOTER_RIGHT, FOOTER_RIGHT_TEXT);
    }

    public void setFooterLeft(String string) {
        this.set(FOOTER_LEFT, string);
    }

    public void setFooterCenter(String string) {
        this.set(FOOTER_CENTER, string);
    }

    public void setFooterRight(String string) {
        this.set(FOOTER_RIGHT, string);
    }

    public Color getFooterColor() {
        return this.getColor(this.get(FOOTER_COLOR, null), Color.black);
    }

    public Font getFooterFont() {
        return this.getFont(this.get(FOOTER_FONT, null), DEFAULT_TITLE_FONT);
    }

    public void setFooterColor(Color color) {
        this.set(FOOTER_COLOR, this.getString(color));
    }

    public void setFooterFont(Font font) {
        this.set(FOOTER_FONT, this.getString(font));
    }

    public void setWrapLines(boolean bl) {
        this.set(WRAP_LINES, bl);
    }

    public boolean isWrapLines() {
        return this.get(WRAP_LINES, false);
    }

    public boolean isLineNumbers() {
        return this.get(LINE_NUMBERS, false);
    }

    public void setLineNumbers(boolean bl) {
        this.set(LINE_NUMBERS, bl);
    }

    public boolean isUseFont() {
        return this.get(USE_FONT, true);
    }

    public void setUseFont(boolean bl) {
        this.set(USE_FONT, bl);
    }

    public boolean isUseColor() {
        return this.get(USE_COLOR, true);
    }

    public void setUseColor(boolean bl) {
        this.set(USE_COLOR, bl);
    }

    public Color getTextColor() {
        return this.getColor(this.get(TEXT_COLOR, null), Color.black);
    }

    public void setTextColor(Color color) {
        this.set(TEXT_COLOR, this.getString(color));
    }

    public Font getTextFont() {
        return this.getFont(this.get(TEXT_FONT, null), DEFAULT_TEXT_FONT);
    }

    public void setTextFont(Font font) {
        this.set(TEXT_FONT, this.getString(font));
    }

    public Color getBackgroundColor() {
        return this.getColor(this.get(BACKGROUND_COLOR, null), DEFAULT_BACGROUND_COLOR);
    }

    public void setBackgroundColor(Color color) {
        this.set(BACKGROUND_COLOR, this.getString(color));
    }

    public double getLineSpacing() {
        return this.get(LINE_SPACING, 1.0);
    }

    public void setLineSpacing(double d) {
        this.set(LINE_SPACING, d);
    }

    public void setZoom(double d) {
        this.set(ZOOM, d);
    }

    public double getZoom() {
        return this.get(ZOOM, 1.0);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(Config.class);
    }

    private String get(String string, String string2) {
        return this.getPreferences().get(string, string2);
    }

    private boolean get(String string, boolean bl) {
        return this.getPreferences().getBoolean(string, bl);
    }

    private double get(String string, double d) {
        return this.getPreferences().getDouble(string, d);
    }

    private void set(String string, String string2) {
        this.getPreferences().put(string, string2);
    }

    private void set(String string, boolean bl) {
        this.getPreferences().putBoolean(string, bl);
    }

    private void set(String string, double d) {
        this.getPreferences().putDouble(string, d);
    }

    private String getString(Color color) {
        return color.getRed() + COMMA + color.getGreen() + COMMA + color.getBlue();
    }

    private String getString(Font font) {
        return font.getName() + COMMA + font.getStyle() + COMMA + font.getSize();
    }

    private Color getColor(String string, Color color) {
        if (string == null) {
            return color;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA);
        int n = this.integer(stringTokenizer);
        int n2 = this.integer(stringTokenizer);
        int n3 = this.integer(stringTokenizer);
        if (n == -1 || n2 == -1 || n3 == -1) {
            return color;
        }
        return new Color(n, n2, n3);
    }

    private Font getFont(String string, Font font) {
        if (string == null) {
            return font;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA);
        String string2 = this.getString(stringTokenizer);
        int n = this.integer(stringTokenizer);
        int n2 = this.integer(stringTokenizer);
        if (string2 == null || n == -1 || n2 == -1) {
            return font;
        }
        return new Font(string2, n, n2);
    }

    private int integer(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            return -1;
        }
        return UI.getInt(stringTokenizer.nextToken());
    }

    private String getString(StringTokenizer stringTokenizer) {
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        return stringTokenizer.nextToken();
    }

    private Rectangle2D getBound(Font font) {
        return font.getMaxCharBounds(FONT_RENDER_CONTEXT);
    }

    public static String getPageOfCount(String string, String string2) {
        return UI.i18n(Config.class, "LBL_Page_of_Count", string, string2);
    }

    private static String getRowColumn(String string, String string2) {
        return UI.i18n(Config.class, "LBL_Row_Column", string, string2);
    }

    public static Config getDefault() {
        return DEFAULT;
    }

    public Graphics2D getGraphics(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        return graphics2D;
    }
}

