/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;

public class FlowNetwork<N, E> {
    private EmbeddedPlanarGraph<N, E> originalGraph;
    private Map<MGraph.Vertex<N>, Node<N>> vertexNodeMap;
    private Map<Face, Node<N>> faceNodeMap;
    public Collection<Node<N>> nodes;
    public Collection<Arc<N>> arcs;
    public Node<N> source;
    public Node<N> sink;

    public static <N, E> FlowNetwork<N, E> createGraph(EmbeddedPlanarGraph<N, E> embeddedPlanarGraph) {
        FlowNetwork<N, E> flowNetwork = new FlowNetwork<N, E>(embeddedPlanarGraph);
        super.createGraph();
        return flowNetwork;
    }

    private FlowNetwork(EmbeddedPlanarGraph<N, E> embeddedPlanarGraph) {
        this.originalGraph = embeddedPlanarGraph;
        this.vertexNodeMap = new HashMap<MGraph.Vertex<N>, Node<N>>();
        this.faceNodeMap = new HashMap<Face, Node<N>>();
        this.nodes = new ArrayList<Node<N>>();
        this.arcs = new ArrayList<Arc<N>>();
    }

    /*
     * WARNING - void declaration
     */
    private void createGraph() {
        void var4_9;
        Object object;
        Object object2;
        Object object3;
        Collection<MGraph.Vertex<N>> collection = this.originalGraph.getOriginalGraph().getVertices();
        ArrayList<Face> arrayList = this.originalGraph.getFaces();
        for (MGraph.Vertex<N> object4 : collection) {
            object3 = this.getNode(object4);
            for (Face face : arrayList) {
                if (!face.containsVertex(object4)) continue;
                object2 = this.getNode(face);
                object = face.getDartsFrom(object4);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Face.Dart dart = (Face.Dart)iterator.next();
                    this.addArc((Node<N>)object3, (Node<N>)object2, dart);
                }
            }
        }
        for (Face face : arrayList) {
            object3 = this.getNode(face);
            for (Face.Dart dart : face.getDarts()) {
                object2 = this.originalGraph.getOppositeFace(face, dart);
                object = this.getNode((Face)object2);
                this.addArc((Node<N>)object3, (Node<N>)object, dart);
            }
        }
        this.source = new Node();
        ((Node)this.source).isSource = true;
        this.sink = new Node();
        ((Node)this.sink).isSink = true;
        int n = 0;
        boolean bl = false;
        for (Node node : this.getNodes()) {
            if (node.production > 0) {
                Arc<N> arc = this.addArc(this.source, node);
                ((Arc)arc).capacity = node.production;
                ((Arc)arc).cost = 0;
                n += node.production;
                continue;
            }
            if (node.production >= 0) continue;
            Arc<N> arc = this.addArc(node, this.sink);
            ((Arc)arc).capacity = -node.production;
            ((Arc)arc).cost = 0;
            var4_9 += node.production;
        }
        ((Node)this.source).production = n;
        ((Node)this.sink).production = (int)var4_9;
    }

    public EmbeddedPlanarGraph<N, E> getOriginalGraph() {
        return this.originalGraph;
    }

    public Node<N> getNode(MGraph.Vertex<N> vertex) {
        Node<N> node = this.vertexNodeMap.get(vertex);
        if (node == null) {
            node = new Node<N>(vertex);
            this.vertexNodeMap.put(vertex, node);
            this.nodes.add(node);
        }
        return node;
    }

    public Node<N> getNode(Face face) {
        Node<N> node = this.faceNodeMap.get(face);
        if (node == null) {
            node = new Node(face);
            this.faceNodeMap.put(face, node);
            this.nodes.add(node);
        }
        return node;
    }

    public Node<N> getSource() {
        return this.source;
    }

    public Node<N> getSink() {
        return this.sink;
    }

    public Arc<N> addArc(Node<N> node, Node<N> node2, Face.Dart dart) {
        Arc<N> arc = new Arc<N>(node, node2, dart);
        this.arcs.add(arc);
        return arc;
    }

    public Arc<N> addArc(Node<N> node, Node<N> node2) {
        return this.addArc(node, node2, null);
    }

    public void removeArc(Arc<N> arc) {
        this.arcs.remove(arc);
        Node<N> node = arc.getSourceNode();
        if (node != null) {
            node.removeOutputArc(arc);
        }
        if ((node = arc.getDestinationNode()) != null) {
            node.removeInputArc(arc);
        }
    }

    public Collection<Node<N>> getNodes() {
        return this.nodes;
    }

    public Collection<Arc<N>> getArcs() {
        return this.arcs;
    }

    public void removeSourceAndSink() {
        this.nodes.remove(this.source);
        this.nodes.remove(this.sink);
        ArrayList<Arc<N>> arrayList = new ArrayList<Arc<N>>(this.source.getOutputArcs());
        for (Arc arc : arrayList) {
            this.removeArc(arc);
        }
        arrayList = new ArrayList<Arc<N>>(this.sink.getInputArcs());
        for (Arc arc : arrayList) {
            this.removeArc(arc);
        }
    }

    public String toString() {
        String string = "Flow Network\n";
        string = string + "Source:\n" + this.source + "\n";
        string = string + "Sink:\n" + this.sink + "\n";
        string = string + "Nodes:\n";
        for (Node<N> node : this.nodes) {
            string = string + node + "\n";
        }
        return string;
    }

    public static class ResidualArc<N>
    extends Arc<N> {
        private boolean isReverse;
        private Arc<N> arc;

        public ResidualArc(Node<N> node, Node<N> node2, Arc<N> arc, boolean bl) {
            super(node, node2, null);
            this.isReverse = bl;
            this.arc = arc;
            if (!bl) {
                this.setCapacity(arc.getCapacity() - arc.getFlow());
            } else {
                this.setCapacity(arc.getFlow());
            }
            this.setCost(arc.getCost());
        }

        public boolean isReverse() {
            return this.isReverse;
        }

        public Arc<N> getArc() {
            return this.arc;
        }

        @Override
        public String toString() {
            String string = "ResidualArc:\n";
            string = string + "isReverse = " + this.isReverse + "\n";
            string = string + "capacity = " + this.getCapacity() + "\n";
            string = string + "cost = " + this.getCost() + "\n";
            string = string + "flow = " + this.getFlow() + "\n";
            return string;
        }
    }

    public static class ResidualFlowNetwork<N, E>
    extends FlowNetwork<N, E> {
        private Map<Arc<N>, ResidualArc<N>> arcToResidualArcMap;
        private Map<Arc<N>, ResidualArc<N>> arcToReverseResidualArcMap;
        private FlowNetwork<N, E> network;
        private Map<Node<N>, Node<N>> nodeMap;

        public ResidualFlowNetwork(FlowNetwork<N, E> flowNetwork) {
            super(null);
            this.network = flowNetwork;
            this.nodeMap = new HashMap<Node<N>, Node<N>>();
            this.arcToResidualArcMap = new HashMap<Arc<N>, ResidualArc<N>>();
            this.arcToReverseResidualArcMap = new HashMap<Arc<N>, ResidualArc<N>>();
            this.source = this.getNode(flowNetwork.getSource());
            this.source.isSource = true;
            this.sink = this.getNode(flowNetwork.getSink());
            this.sink.isSink = true;
            for (Arc<N> arc : flowNetwork.getArcs()) {
                this.addResidualArc(arc);
            }
        }

        private void addResidualArc(Arc<N> arc) {
            Node<N> node = this.getNode(arc.getSourceNode());
            Node<N> node2 = this.getNode(arc.getDestinationNode());
            ResidualArc<N> residualArc = new ResidualArc<N>(node, node2, arc, false);
            this.arcToResidualArcMap.put(arc, residualArc);
            ResidualArc<N> residualArc2 = new ResidualArc<N>(node2, node, arc, true);
            this.arcToReverseResidualArcMap.put(arc, residualArc2);
        }

        public ResidualArc<N> getResidualArcFromArc(Arc<N> arc) {
            return this.arcToResidualArcMap.get(arc);
        }

        public ResidualArc<N> getReverseResidualArcFromArc(Arc<N> arc) {
            return this.arcToReverseResidualArcMap.get(arc);
        }

        @Override
        private Node<N> getNode(Node<N> node) {
            Node<N> node2 = this.nodeMap.get(node);
            if (node2 == null) {
                if (node.isVertexNode()) {
                    node2 = ((FlowNetwork)this).getNode(node.getVertex());
                } else if (node.isFaceNode()) {
                    node2 = this.getNode(node.getFace());
                } else {
                    node2 = new Node();
                    node2.setProduction(node.getProduction());
                    this.nodes.add(node2);
                }
                this.nodeMap.put(node, node2);
            }
            return node2;
        }
    }

    public static class Arc<N> {
        private Node<N> sourceNode;
        private Node<N> destinationNode;
        private int capacity;
        private int cost;
        private int flow;
        private int lowerBound;
        private Face.Dart dart;

        public Arc(Node<N> node, Node<N> node2, Face.Dart dart) {
            this.sourceNode = node;
            this.destinationNode = node2;
            this.dart = dart;
            this.flow = 0;
            if (this.sourceNode.isVertexNode() || node2.isVertexNode()) {
                this.lowerBound = 0;
                this.capacity = 3;
                this.cost = 0;
            } else if (this.sourceNode.isFaceNode() && this.destinationNode.isFaceNode()) {
                this.lowerBound = 0;
                this.capacity = Integer.MAX_VALUE;
                this.cost = 1;
            }
            this.sourceNode.addOutputArc(this);
            this.destinationNode.addInputArc(this);
        }

        public Node<N> getSourceNode() {
            return this.sourceNode;
        }

        public Node<N> getDestinationNode() {
            return this.destinationNode;
        }

        public Face.Dart getDart() {
            return this.dart;
        }

        public int getCost() {
            return this.cost;
        }

        public void setCost(int n) {
            this.cost = n;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public void setCapacity(int n) {
            this.capacity = n;
        }

        public void setFlow(int n) {
            this.flow = n;
        }

        public int getFlow() {
            return this.flow;
        }

        public void addFlow(int n) {
            this.flow += n;
        }

        public void substractCapacity(int n) {
            this.capacity -= n;
        }

        public void addCapacity(int n) {
            this.capacity += n;
        }

        public boolean isVertexArc() {
            return this.sourceNode.isVertexNode();
        }

        public boolean isFaceArc() {
            return this.sourceNode.isFaceNode() && this.destinationNode.isFaceNode();
        }

        public String toString() {
            String string = "Arc:\n";
            string = string + "capacity = " + this.capacity + "\n";
            string = string + "cost = " + this.cost + "\n";
            string = string + "flow = " + this.flow + "\n";
            string = string + "lowerBound = " + this.lowerBound + "\n";
            return string;
        }
    }

    public static class Node<N> {
        private Face face;
        private MGraph.Vertex<N> vertex;
        private Collection<Arc<N>> inputArcs = new ArrayList<Arc<N>>();
        private Collection<Arc<N>> outputArcs = new ArrayList<Arc<N>>();
        private int production;
        private boolean isSource;
        private boolean isSink;

        public Node() {
        }

        public Node(Face face) {
            this();
            this.face = face;
            int n = face.getDegree();
            this.production = face.isOuterFace() ? -(1 * n + 4) : (n == 2 ? 0 : -(1 * n - 4));
        }

        public Node(MGraph.Vertex<N> vertex) {
            this();
            this.vertex = vertex;
            this.production = 4 - vertex.getDegree();
        }

        public MGraph.Vertex<N> getVertex() {
            return this.vertex;
        }

        public Face getFace() {
            return this.face;
        }

        public boolean isFaceNode() {
            return this.face != null;
        }

        public boolean isVertexNode() {
            return this.vertex != null;
        }

        public void addInputArc(Arc<N> arc) {
            this.inputArcs.add(arc);
        }

        public void removeInputArc(Arc<N> arc) {
            this.inputArcs.remove(arc);
        }

        public void addOutputArc(Arc<N> arc) {
            this.outputArcs.add(arc);
        }

        public void removeOutputArc(Arc<N> arc) {
            this.outputArcs.remove(arc);
        }

        public Collection<Arc<N>> getInputArcs() {
            return this.inputArcs;
        }

        public Collection<Arc<N>> getOutputArcs() {
            return this.outputArcs;
        }

        public Arc<N> getArcToVia(Node<N> node, Face.Dart dart) {
            MGraph.Edge<?> edge = dart.getEdge();
            for (Arc<N> arc : this.outputArcs) {
                if (arc.getDestinationNode() != node || arc.getDart().getEdge() != edge) continue;
                return arc;
            }
            return null;
        }

        public int getProduction() {
            return this.production;
        }

        public void setProduction(int n) {
            this.production = n;
        }

        public String toString() {
            String string = "Node: \n";
            if (this.isSource) {
                string = "Source Node:\n";
            } else if (this.isSink) {
                string = "Sink Node:\n";
            }
            string = string + "hashCode: " + this.hashCode() + "\n";
            string = string + "vertex: " + this.vertex + "\n";
            string = string + "face: " + this.face + "\n";
            string = string + "production: " + this.production + "\n";
            return string;
        }
    }
}

