/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.drpc;

import java.util.concurrent.Semaphore;
import org.apache.storm.daemon.drpc.OutstandingRequest;
import org.apache.storm.daemon.drpc.RequestFactory;
import org.apache.storm.generated.DRPCExceptionType;
import org.apache.storm.generated.DRPCExecutionException;
import org.apache.storm.generated.DRPCRequest;
import org.apache.storm.utils.WrappedDRPCExecutionException;

public class BlockingOutstandingRequest
extends OutstandingRequest {
    public static final RequestFactory<BlockingOutstandingRequest> FACTORY = BlockingOutstandingRequest::new;
    private Semaphore sem = new Semaphore(0);
    private volatile String result = null;
    private volatile DRPCExecutionException drpcExecutionException = null;

    public BlockingOutstandingRequest(String function, DRPCRequest req) {
        super(function, req);
    }

    public String getResult() throws DRPCExecutionException {
        try {
            this.sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.result != null) {
            return this.result;
        }
        if (this.drpcExecutionException == null) {
            this.drpcExecutionException = new WrappedDRPCExecutionException("Internal Error: No Result and No Exception");
            this.drpcExecutionException.set_type(DRPCExceptionType.INTERNAL_ERROR);
        }
        throw this.drpcExecutionException;
    }

    @Override
    public void returnResult(String result) {
        this.result = result;
        this.sem.release();
    }

    @Override
    public void fail(DRPCExecutionException e) {
        this.drpcExecutionException = e;
        this.sem.release();
    }
}

