/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.type;

import java.io.File;
import java.io.IOException;
import net.sourceforge.argparse4j.helper.MessageLocalization;
import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.impl.type.FileVerificationStep;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;

public class FileVerification {
    public boolean verifyExists = false;
    public boolean verifyNotExists = false;
    public boolean verifyIsFile = false;
    public boolean verifyIsDirectory = false;
    public boolean verifyCanRead = false;
    public boolean verifyCanWrite = false;
    public boolean verifyCanWriteParent = false;
    public boolean verifyCanCreate = false;
    public boolean verifyCanExecute = false;
    public boolean verifyIsAbsolute = false;
    private FileVerification nextFileVerification;

    public FileVerification or() {
        this.nextFileVerification = new FileVerification();
        return this.nextFileVerification;
    }

    public void verify(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        FileVerificationStep verifyPresenceAndType;
        if (this.verifyIsAbsolute) {
            this.verifyIsAbsolute(parser, arg, file);
        }
        if (!this.verifyStep(verifyPresenceAndType = () -> this.verifyPresenceAndType(parser, arg, file))) {
            this.nextFileVerification.verify(parser, arg, file);
        } else {
            FileVerificationStep verifyPermissions = () -> this.verifyPermissions(parser, arg, file);
            if (!this.verifyStep(verifyPermissions)) {
                this.nextFileVerification.verify(parser, arg, file);
            }
        }
    }

    private boolean verifyStep(FileVerificationStep step) throws ArgumentParserException {
        boolean result = true;
        try {
            step.verify();
        }
        catch (ArgumentParserException e) {
            if (this.nextFileVerification == null) {
                throw e;
            }
            result = false;
        }
        return result;
    }

    private void verifyPresenceAndType(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (this.verifyExists) {
            this.verifyExists(parser, arg, file);
        }
        if (this.verifyNotExists) {
            this.verifyNotExists(parser, arg, file);
        }
        if (this.verifyIsFile) {
            this.verifyIsFile(parser, arg, file);
        }
        if (this.verifyIsDirectory) {
            this.verifyIsDirectory(parser, arg, file);
        }
    }

    private void verifyPermissions(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (this.verifyCanRead) {
            this.verifyCanRead(parser, arg, file);
        }
        if (this.verifyCanWrite) {
            this.verifyCanWrite(parser, arg, file);
        }
        if (this.verifyCanWriteParent) {
            this.verifyCanWriteParent(parser, arg, file);
        }
        if (this.verifyCanCreate) {
            this.verifyCanCreate(parser, arg, file);
        }
        if (this.verifyCanExecute) {
            this.verifyCanExecute(parser, arg, file);
        }
    }

    private void verifyExists(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!this.exists(file)) {
            this.throwException(parser, arg, file, "fileNotFoundError");
        }
    }

    private void verifyNotExists(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (this.exists(file)) {
            this.throwException(parser, arg, file, "fileFoundError");
        }
    }

    private void verifyIsFile(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!this.isFile(file)) {
            this.throwException(parser, arg, file, "notAFileError");
        }
    }

    private void verifyIsDirectory(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!this.isDirectory(file)) {
            this.throwException(parser, arg, file, "notADirectoryError");
        }
    }

    private void verifyCanRead(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!this.canRead(file)) {
            this.throwException(parser, arg, file, "insufficientPermissionsToReadFileError");
        }
    }

    private void verifyCanWrite(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!this.canWrite(file)) {
            this.throwException(parser, arg, file, "insufficientPermissionsToWriteFileError");
        }
    }

    private void verifyCanWriteParent(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        File parent = file.getParentFile();
        if (parent == null || !this.canWrite(parent)) {
            this.throwException(parser, arg, file, "cannotWriteParentOfFileError");
        }
    }

    private void verifyCanCreate(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        try {
            File parent = file.getCanonicalFile().getParentFile();
            if (parent != null && this.canWrite(parent)) {
                return;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.throwException(parser, arg, file, "cannotCreateFileError");
    }

    private void verifyCanExecute(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!this.canExecute(file)) {
            this.throwException(parser, arg, file, "insufficientPermissionsToExecuteFileError");
        }
    }

    private void verifyIsAbsolute(ArgumentParser parser, Argument arg, File file) throws ArgumentParserException {
        if (!file.isAbsolute()) {
            this.throwException(parser, arg, file, "notAnAbsoluteFileError");
        }
    }

    private void throwException(ArgumentParser parser, Argument arg, File file, String messageKey) throws ArgumentParserException {
        throw new ArgumentParserException(String.format(TextHelper.LOCALE_ROOT, MessageLocalization.localize(parser.getConfig().getResourceBundle(), messageKey), file), parser, arg);
    }

    protected boolean exists(File file) {
        return file.exists();
    }

    protected boolean isDirectory(File file) {
        return file.isDirectory();
    }

    protected boolean isFile(File file) {
        return file.isFile();
    }

    protected boolean canRead(File file) {
        return file.canRead();
    }

    protected boolean canWrite(File file) {
        return file.canWrite();
    }

    protected boolean canExecute(File file) {
        return file.canExecute();
    }
}

