/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class MetaCacheUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MetaCacheUtil.class);

    private MetaCacheUtil() {
    }

    static void cleanProblematicOverlappedRegions(RegionLocations locations, ConcurrentNavigableMap<byte[], RegionLocations> cache) {
        RegionInfo region = locations.getRegionLocation().getRegion();
        boolean isLast = ConnectionUtils.isEmptyStopRow(region.getEndKey());
        while (true) {
            Map.Entry overlap;
            Map.Entry entry = overlap = isLast ? cache.lastEntry() : cache.lowerEntry(region.getEndKey());
            if (overlap == null || overlap.getValue() == locations || Bytes.equals((byte[])((byte[])overlap.getKey()), (byte[])region.getStartKey())) break;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removing cached location {} (endKey={}) because it overlaps with new location {} (endKey={})", new Object[]{overlap.getValue(), Bytes.toStringBinary((byte[])((RegionLocations)overlap.getValue()).getRegionLocation().getRegion().getEndKey()), locations, Bytes.toStringBinary((byte[])locations.getRegionLocation().getRegion().getEndKey())});
            }
            cache.remove(overlap.getKey());
        }
    }
}

