/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.ws;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.servicecomb.swagger.invocation.InvocationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialExecutorWrapper
implements Executor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialExecutorWrapper.class);
    private static final int LEAST_QUEUE_CAPACITY = 100;
    private final InvocationType invocationType;
    private final String id;
    private final Queue<Runnable> queue;
    private final Executor workerPool;
    private final int queueCapacity;
    private final int drainThreshold;
    private final int fullThreshold;
    private final AtomicBoolean scheduleFlag;
    private final int maxContinueTimes;
    private QueueDrainSubscriber queueDrainSubscriber;
    private QueueFullSubscriber queueFullSubscriber;

    public SerialExecutorWrapper(InvocationType invocationType, String id, Executor workerPool, int queueCapacity, int maxContinueTimes) {
        this.invocationType = invocationType;
        this.id = id;
        this.workerPool = workerPool;
        this.queueCapacity = this.correctQueueCapacity(queueCapacity);
        this.queue = new ArrayBlockingQueue<Runnable>(this.calculateRealQueueSize(), true);
        this.drainThreshold = this.calculateDrainThreshold();
        this.fullThreshold = this.calculateFullThreshold();
        this.scheduleFlag = new AtomicBoolean();
        this.maxContinueTimes = this.correctMaxContinueTimes(maxContinueTimes);
    }

    public void subscribeQueueDrainEvent(QueueDrainSubscriber subscriber) {
        if (subscriber != null) {
            this.queueDrainSubscriber = subscriber;
        }
    }

    public void subscribeQueueFullEvent(QueueFullSubscriber subscriber) {
        if (subscriber != null) {
            this.queueFullSubscriber = subscriber;
        }
    }

    @Override
    public void execute(Runnable command) {
        Objects.requireNonNull(command, "command must not be null");
        Objects.requireNonNull(this.queueDrainSubscriber, "queueDrainSubscriber must not be null");
        this.queue.add(command);
        this.markQueueFull();
        this.scheduleWorker();
    }

    private void scheduleWorker() {
        if (!this.scheduleFlag.compareAndSet(false, true)) {
            return;
        }
        try {
            this.workerPool.execute(() -> {
                try {
                    this.runTasks();
                }
                finally {
                    this.scheduleFlag.set(false);
                    if (!this.queue.isEmpty()) {
                        this.scheduleWorker();
                    }
                }
            });
        }
        catch (Throwable e) {
            this.scheduleFlag.set(false);
            LOGGER.error("[{}]-[{}] failed to execute task in actual thread pool!", new Object[]{this.invocationType, this.id, e});
        }
    }

    private void runTasks() {
        Runnable task;
        int workCount = 1;
        while ((task = this.queue.poll()) != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                LOGGER.error("[{}]-[{}] error occurred while executing task[{}]", new Object[]{this.invocationType, this.id, task, e});
            }
            if (++workCount <= this.maxContinueTimes) continue;
            break;
        }
        this.notifyIfQueueDrain();
    }

    private void markQueueFull() {
        QueueFullSubscriber subscriber = this.queueFullSubscriber;
        if (subscriber == null) {
            return;
        }
        if (this.queue.size() < this.fullThreshold) {
            return;
        }
        LOGGER.warn("[{}]-[{}] queue nearly full! queue length: {}/{}", new Object[]{this.invocationType, this.id, this.queue.size(), this.calculateRealQueueSize()});
        try {
            subscriber.run();
        }
        catch (Throwable e) {
            LOGGER.error("[{}]-[{}] error occurred while notifying queue full subscriber[{}]", new Object[]{this.invocationType, this.id, subscriber, e});
        }
        if (this.queue.size() < this.drainThreshold) {
            this.execute(this::notifyIfQueueDrain);
        }
    }

    private void notifyIfQueueDrain() {
        QueueDrainSubscriber subscriber = this.queueDrainSubscriber;
        if (subscriber == null) {
            return;
        }
        if (this.queue.size() > this.drainThreshold) {
            return;
        }
        try {
            subscriber.run();
        }
        catch (Throwable e) {
            LOGGER.error("[{}]-[{}] error occurred while notifying queue drain subscriber[{}]", new Object[]{this.invocationType, this.id, subscriber, e});
        }
    }

    private int calculateRealQueueSize() {
        return (int)((double)this.queueCapacity * 1.2);
    }

    private int calculateDrainThreshold() {
        return (int)((double)this.queueCapacity * 0.25);
    }

    private int calculateFullThreshold() {
        return this.queueCapacity;
    }

    private int correctQueueCapacity(int queueCapacity) {
        if (queueCapacity < 100) {
            LOGGER.warn("queue capacity less than 10 does not make sense, adjust to {}", (Object)100);
            return 100;
        }
        return queueCapacity;
    }

    private int correctMaxContinueTimes(int maxContinueTimes) {
        if (maxContinueTimes < 1) {
            LOGGER.warn("maxContinueTimes less than 1 does not make sense, adjust to 1");
            return 1;
        }
        return maxContinueTimes;
    }

    public static interface QueueFullSubscriber {
        public void run();
    }

    public static interface QueueDrainSubscriber {
        public void run();
    }
}

