/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager.ldap;

import javax.net.ssl.SSLSocketFactory;

public class ThreadLocalLdapSslSocketFactory {
    private static final ThreadLocal<SSLSocketFactory> THREAD_LOCAL = new ThreadLocal();

    private ThreadLocalLdapSslSocketFactory() {
    }

    public static SSLSocketFactory getDefault() {
        SSLSocketFactory result = THREAD_LOCAL.get();
        if (result == null) {
            throw new IllegalStateException("SSLSocketFactory instance not available");
        }
        return result;
    }

    public static void set(SSLSocketFactory factory) {
        THREAD_LOCAL.set(factory);
    }

    public static void remove() {
        THREAD_LOCAL.remove();
    }
}

