/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.port;

import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AbstractPort;
import org.apache.qpid.server.model.port.HttpPort;
import org.apache.qpid.server.model.port.PortManager;

public class HttpPortImpl
extends AbstractPort<HttpPortImpl>
implements HttpPort<HttpPortImpl> {
    private PortManager _portManager;
    @ManagedAttributeField
    private int _threadPoolMaximum;
    @ManagedAttributeField
    private int _threadPoolMinimum;
    @ManagedAttributeField
    private boolean _manageBrokerOnNoAliasMatch;
    private volatile int _numberOfAcceptors;
    private volatile int _numberOfSelectors;
    private volatile int _acceptsBacklogSize;
    private volatile long _absoluteSessionTimeout;
    private volatile int _tlsSessionTimeout;
    private volatile int _tlsSessionCacheSize;

    @ManagedObjectFactoryConstructor
    public HttpPortImpl(Map<String, Object> attributes, Container<?> container) {
        super(attributes, container);
    }

    @Override
    public void setPortManager(PortManager manager) {
        this._portManager = manager;
    }

    @Override
    public int getBoundPort() {
        PortManager portManager = this.getPortManager();
        return portManager == null ? -1 : portManager.getBoundPort(this);
    }

    @Override
    public int getThreadPoolMaximum() {
        return this._threadPoolMaximum;
    }

    @Override
    public int getThreadPoolMinimum() {
        return this._threadPoolMinimum;
    }

    @Override
    public boolean isManageBrokerOnNoAliasMatch() {
        return this._manageBrokerOnNoAliasMatch;
    }

    @Override
    public int getDesiredNumberOfAcceptors() {
        return this._numberOfAcceptors;
    }

    @Override
    public int getDesiredNumberOfSelectors() {
        return this._numberOfSelectors;
    }

    @Override
    public int getAcceptBacklogSize() {
        return this._acceptsBacklogSize;
    }

    @Override
    public int getNumberOfAcceptors() {
        PortManager portManager = this.getPortManager();
        return portManager == null ? 0 : portManager.getNumberOfAcceptors(this);
    }

    @Override
    public int getNumberOfSelectors() {
        PortManager portManager = this.getPortManager();
        return portManager == null ? 0 : portManager.getNumberOfSelectors(this);
    }

    @Override
    public int getTLSSessionTimeout() {
        return this._tlsSessionTimeout;
    }

    @Override
    public int getTLSSessionCacheSize() {
        return this._tlsSessionCacheSize;
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._acceptsBacklogSize = this.getContextValue(Integer.class, "qpid.port.http.acceptBacklog");
        this._numberOfAcceptors = this.getContextValue(Integer.class, "qpid.port.http.threadPool.numberOfAcceptors");
        this._numberOfSelectors = this.getContextValue(Integer.class, "qpid.port.http.threadPool.numberOfSelectors");
        this._absoluteSessionTimeout = this.getContextValue(Long.class, "qpid.port.http.absoluteSessionTimeout");
        this._tlsSessionTimeout = this.getContextValue(Integer.class, "qpid.port.http.tlsSessionTimeout");
        this._tlsSessionCacheSize = this.getContextValue(Integer.class, "qpid.port.http.tlsSessionCacheSize");
    }

    @Override
    protected State onActivate() {
        if (this.getPortManager() != null) {
            return super.onActivate();
        }
        return State.QUIESCED;
    }

    @Override
    public SSLContext getSSLContext() {
        PortManager portManager = this.getPortManager();
        return portManager == null ? null : portManager.getSSLContext(this);
    }

    @Override
    protected boolean updateSSLContext() {
        if (this.getTransports().contains((Object)Transport.SSL)) {
            PortManager portManager = this.getPortManager();
            return portManager != null && portManager.updateSSLContext(this);
        }
        return false;
    }

    private PortManager getPortManager() {
        return this._portManager;
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validateThreadPoolSettings(this);
        int acceptsBacklogSize = this.getContextValue(Integer.class, "qpid.port.http.acceptBacklog");
        if (acceptsBacklogSize < 1) {
            throw new IllegalConfigurationException(String.format("The size of accept backlog %d is too small. Must be greater than zero.", acceptsBacklogSize));
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        HttpPort changed = (HttpPort)proxyForValidation;
        if (changedAttributes.contains("threadPoolMaximum") || changedAttributes.contains("threadPoolMinimum")) {
            this.validateThreadPoolSettings(changed);
        }
    }

    @Override
    public long getAbsoluteSessionTimeout() {
        return this._absoluteSessionTimeout;
    }

    private void validateThreadPoolSettings(HttpPort<?> httpPort) {
        if (httpPort.getThreadPoolMaximum() < 1) {
            throw new IllegalConfigurationException(String.format("Thread pool maximum %d is too small. Must be greater than zero.", httpPort.getThreadPoolMaximum()));
        }
        if (httpPort.getThreadPoolMinimum() < 1) {
            throw new IllegalConfigurationException(String.format("Thread pool minimum %d is too small. Must be greater than zero.", httpPort.getThreadPoolMinimum()));
        }
        if (httpPort.getThreadPoolMinimum() > httpPort.getThreadPoolMaximum()) {
            throw new IllegalConfigurationException(String.format("Thread pool minimum %d cannot be greater than thread pool maximum %d.", httpPort.getThreadPoolMinimum(), httpPort.getThreadPoolMaximum()));
        }
    }
}

