/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.admin.cli;

import com.google.common.base.Strings;
import java.util.function.Supplier;
import lombok.NonNull;
import org.apache.pulsar.admin.cli.CliCommand;
import org.apache.pulsar.admin.cli.CmdBase;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.policies.data.BookieInfo;
import picocli.CommandLine;

@CommandLine.Command(description={"Operations about bookies rack placement"})
public class CmdBookies
extends CmdBase {
    public CmdBookies(Supplier<PulsarAdmin> admin) {
        super("bookies", admin);
        this.addCommand("racks-placement", new GetAll());
        this.addCommand("list-bookies", new ListBookies());
        this.addCommand("get-bookie-rack", new GetBookie());
        this.addCommand("delete-bookie-rack", new RemoveBookie());
        this.addCommand("set-bookie-rack", new UpdateBookie());
    }

    @CommandLine.Command(description={"Gets the rack placement information for all the bookies in the cluster"})
    private class GetAll
    extends CliCommand {
        private GetAll() {
        }

        @Override
        void run() throws Exception {
            this.prettyPrint(CmdBookies.this.getAdmin().bookies().getBookiesRackInfo());
        }
    }

    @CommandLine.Command(description={"List bookies"})
    private class ListBookies
    extends CliCommand {
        private ListBookies() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBookies.this.getAdmin().bookies().getBookies());
        }
    }

    @CommandLine.Command(description={"Gets the rack placement information for a specific bookie in the cluster"})
    private class GetBookie
    extends CliCommand {
        @CommandLine.Option(names={"-b", "--bookie"}, description={"Bookie address (format: `address:port`)"}, required=true)
        private String bookieAddress;

        private GetBookie() {
        }

        @Override
        void run() throws Exception {
            this.print(CmdBookies.this.getAdmin().bookies().getBookieRackInfo(this.bookieAddress));
        }
    }

    @CommandLine.Command(description={"Remove rack placement information for a specific bookie in the cluster"})
    private class RemoveBookie
    extends CliCommand {
        @CommandLine.Option(names={"-b", "--bookie"}, description={"Bookie address (format: `address:port`)"}, required=true)
        private String bookieAddress;

        private RemoveBookie() {
        }

        @Override
        void run() throws Exception {
            CmdBookies.this.getAdmin().bookies().deleteBookieRackInfo(this.bookieAddress);
        }
    }

    @CommandLine.Command(description={"Updates the rack placement information for a specific bookie in the cluster (note. bookie address format:`address:port`)"})
    private class UpdateBookie
    extends CliCommand {
        private static final String PATH_SEPARATOR = "/";
        @CommandLine.Option(names={"-g", "--group"}, description={"Bookie group name"}, required=false)
        private String group = "default";
        @CommandLine.Option(names={"-b", "--bookie"}, description={"Bookie address (format: `address:port`)"}, required=true)
        private String bookieAddress;
        @CommandLine.Option(names={"-r", "--rack"}, description={"Bookie rack name. If you set a bookie rack name to slash (/) or an empty string (\"\"): when using Pulsar earlier than 2.7.5, 2.8.3, and 2.9.2, an exception is thrown; if you use Pulsar 2.7.5, 2.8.3, 2.9.2 or later versions, it falls back to /default-rack or /default-region/default-rack.When `RackawareEnsemblePlacementPolicy` is enabled, the rack name is not allowed to contain slash (/) except for the beginning and end of the rack name string. For example, rack name like /rack0 is okay, but /rack/0 is not allowed. When `RegionawareEnsemblePlacementPolicy` is enabled, the rack name can only contain one slash (/) except for the beginning and end of the rack name string. For example, rack name like /region0/rack0 is okay, but /region0rack0 and /region0/rack/0 are not allowed."}, required=true)
        private String bookieRack;
        @CommandLine.Option(names={"-hn", "--hostname"}, description={"Bookie host name"}, required=false)
        private String bookieHost;

        private UpdateBookie() {
        }

        @Override
        void run() throws Exception {
            this.checkArgument(!Strings.isNullOrEmpty((String)this.bookieRack) && !this.bookieRack.trim().equals(PATH_SEPARATOR), "rack name is invalid, it should not be null, empty or '/'");
            CmdBookies.this.getAdmin().bookies().updateBookieRackInfo(this.bookieAddress, this.group, BookieInfo.builder().rack(this.bookieRack).hostname(this.bookieHost).build());
        }

        private void checkArgument(boolean expression, @NonNull Object errorMessage) {
            if (errorMessage == null) {
                throw new NullPointerException("errorMessage is marked non-null but is null");
            }
            if (!expression) {
                throw new CliCommand.ParameterException(String.valueOf(errorMessage));
            }
        }
    }
}

