/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.util.function.Supplier;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class BeanStoreEntry<T> {
    final Supplier<T> bean;
    final Class<T> type;
    final String name;

    public static <T> BeanStoreEntry<T> create(Class<T> type, Supplier<T> bean, String name) {
        return new BeanStoreEntry<T>(type, bean, name);
    }

    protected BeanStoreEntry(Class<T> type, Supplier<T> bean, String name) {
        this.bean = AssertionUtils.assertArgNotNull("bean", bean);
        this.type = AssertionUtils.assertArgNotNull("type", type);
        this.name = Utils.nullIfEmpty(name);
    }

    public T get() {
        return this.bean.get();
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean matches(Class<?> type) {
        return this.type.equals(type);
    }

    public boolean matches(Class<?> type, String name) {
        name = Utils.nullIfEmpty(name);
        return this.matches(type) && Utils.eq(this.name, name);
    }

    protected JsonMap properties() {
        return JsonMap.filteredMap().append("type", Utils.cns(this.getType())).append("bean", Utils.id(this.get())).append("name", this.getName());
    }
}

