/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.sparql.modify;

import org.apache.jena.sparql.core.DatasetGraph ;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.engine.binding.Binding ;
import org.apache.jena.sparql.util.Context ;
import org.apache.jena.update.UpdateProcessorStreaming ;

/** Class to hold the general state of a update request execution.
 *  See query ExecutionContext
 */
public class UpdateProcessorStreamingBase implements UpdateProcessorStreaming
{
    protected final DatasetGraph datasetGraph ;
    protected final Context context ;
    
    protected final UpdateEngine proc;
    protected final Prologue prologue;

    public UpdateProcessorStreamingBase(DatasetGraph datasetGraph, Binding inputBinding, Prologue prologue, Context context, UpdateEngineFactory factory)
    {
        this.datasetGraph = datasetGraph ;
        this.prologue = prologue;
        this.context = context;
        Context.setCurrentDateTime(this.context) ;
        proc = factory.create(datasetGraph, inputBinding, context) ;
    }
    
    @Override
    public void startRequest() {
        proc.startRequest() ;
    }

    @Override
    public void finishRequest() {
        proc.finishRequest() ;
    }

    @Override
    public UpdateSink getUpdateSink() {
        return proc.getUpdateSink() ;
    }

    @Override
    public DatasetGraph getDatasetGraph() {
        return datasetGraph ;
    }

    @Override
    public Context getContext() {
        return context ;
    }

    @Override
    public Prologue getPrologue() {
        return prologue;
    }
}
