/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentNotFoundException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegmentedPage;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.pagemgr.PageIndexSortBuckets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaPageContext {
    protected static final Logger logger = LoggerFactory.getLogger(SchemaPageContext.class);
    final long threadID = Thread.currentThread().getId();
    final PageIndexSortBuckets indexBuckets;
    final Map<Integer, ISchemaPage> referredPages = new HashMap<Integer, ISchemaPage>();
    final Set<Integer> lockTraces;
    final int[] treeTrace;
    int dirtyCnt = 0;
    int interleavedFlushCnt = 0;
    static boolean lockFaultTrigger = true;
    ISegmentedPage lastLeafPage = null;

    public SchemaPageContext() {
        this.indexBuckets = new PageIndexSortBuckets(SchemaFileConfig.SEG_SIZE_LST, this.referredPages);
        this.treeTrace = new int[16];
        this.lockTraces = new HashSet<Integer>();
    }

    public void markDirty(ISchemaPage page) {
        this.markDirty(page, false);
    }

    public void markDirty(ISchemaPage page, boolean forceReplace) {
        if (!page.isDirtyPage()) {
            ++this.dirtyCnt;
        }
        page.setDirtyFlag();
        this.refer(page);
        if (forceReplace && this.referredPages.containsKey(page.getPageIndex())) {
            if (this.referredPages.get(page.getPageIndex()).isDirtyPage()) {
                --this.dirtyCnt;
            }
            this.referredPages.put(page.getPageIndex(), page);
        }
    }

    public void traceLock(ISchemaPage page) throws SegmentNotFoundException {
        this.refer(page);
        if (this.lockTraces.contains(page.getPageIndex())) {
            if (this.referredPages.get(page.getPageIndex()) != page) {
                logger.error("Duplicate page instances with identical index: {}", (Object)page.getPageIndex());
            }
            if (((ReentrantReadWriteLock)page.getLock()).getWriteHoldCount() > 1) {
                logger.warn("Page [{}] had been locked {} times.", (Object)((ReentrantReadWriteLock)page.getLock()).getWriteHoldCount());
                page.getLock().writeLock().unlock();
                if (lockFaultTrigger) {
                    logger.warn("Reentrant write locks on page {}, content detail:{}", (Object)page.getPageIndex(), (Object)page.inspect());
                    lockFaultTrigger = false;
                } else {
                    logger.warn("Reentrant write locks on page:{}", (Object)page.getPageIndex());
                }
                return;
            }
        }
        this.lockTraces.add(page.getPageIndex());
    }

    public void refer(ISchemaPage page) {
        if (!this.referredPages.containsKey(page.getPageIndex())) {
            page.incrementAndGetRefCnt();
            this.referredPages.put(page.getPageIndex(), page);
        }
    }

    public void invokeLastLeaf(ISchemaPage page) {
        if (this.lastLeafPage == null) {
            this.lastLeafPage = page.getAsSegmentedPage();
        }
    }

    public void appendBucketIndex(PageIndexSortBuckets pisb) {
        for (int i = 0; i < SchemaFileConfig.SEG_SIZE_LST.length; ++i) {
            pisb.getBucket(i).addAll(this.indexBuckets.getBucket(i));
        }
    }
}

