/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */

package gorm

import grails.gorm.transactions.Rollback
import grails.testing.mixin.integration.Integration
import spock.lang.*

@Integration(applicationClass = Application)
@Rollback
class ProductSpec extends Specification {

    void "Test unique constraint persistence"() {
        when:"A new unique product is created"
            def p = new Product(isbn: '123')

        then:"It is valid"
            p.validate()
            !p.hasErrors()

        when:"When it is persisted"
            p.save(flush:true)

        then:"The object is saved correctly"
            Product.count() == 1

        when:"Another product is created that violates the unique constraint"
            def p2 = new Product(isbn: '123')

        then:"The other product does not validate"
            !p2.validate()
            Product.count() == 1
    }
}
