/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.fieldsel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.fieldsel.FieldSelectionHelper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FieldSelectionMapper<K, V>
extends Mapper<K, V, Text, Text> {
    private String mapOutputKeyValueSpec;
    private boolean ignoreInputKey;
    private String fieldSeparator = "\t";
    private List<Integer> mapOutputKeyFieldList = new ArrayList<Integer>();
    private List<Integer> mapOutputValueFieldList = new ArrayList<Integer>();
    private int allMapValueFieldsFrom = -1;
    public static final Logger LOG = LoggerFactory.getLogger("FieldSelectionMapReduce");

    @Override
    public void setup(Mapper.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.fieldSeparator = conf.get("mapreduce.fieldsel.data.field.separator", "\t");
        this.mapOutputKeyValueSpec = conf.get("mapreduce.fieldsel.map.output.key.value.fields.spec", "0-:");
        try {
            this.ignoreInputKey = TextInputFormat.class.getCanonicalName().equals(context.getInputFormatClass().getCanonicalName());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Input format class not found", e);
        }
        this.allMapValueFieldsFrom = FieldSelectionHelper.parseOutputKeyValueSpec(this.mapOutputKeyValueSpec, this.mapOutputKeyFieldList, this.mapOutputValueFieldList);
        LOG.info(FieldSelectionHelper.specToString(this.fieldSeparator, this.mapOutputKeyValueSpec, this.allMapValueFieldsFrom, this.mapOutputKeyFieldList, this.mapOutputValueFieldList) + "\nignoreInputKey:" + this.ignoreInputKey);
    }

    @Override
    public void map(K key, V val, Mapper.Context context) throws IOException, InterruptedException {
        FieldSelectionHelper helper = new FieldSelectionHelper(FieldSelectionHelper.emptyText, FieldSelectionHelper.emptyText);
        helper.extractOutputKeyValue(key.toString(), val.toString(), this.fieldSeparator, this.mapOutputKeyFieldList, this.mapOutputValueFieldList, this.allMapValueFieldsFrom, this.ignoreInputKey, true);
        context.write(helper.getKey(), helper.getValue());
    }
}

