/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import io.netty.channel.ChannelPipeline;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolLogger;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrameInterceptor;
import org.apache.activemq.artemis.core.protocol.stomp.StompPostReceiptFunction;
import org.apache.activemq.artemis.core.protocol.stomp.StompProtocolManagerFactory;
import org.apache.activemq.artemis.core.protocol.stomp.StompSession;
import org.apache.activemq.artemis.core.protocol.stomp.StompVersions;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.routing.RoutingHandler;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompProtocolManager
extends AbstractProtocolManager<StompFrame, StompFrameInterceptor, StompConnection, RoutingHandler> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final List<String> websocketRegistryNames = Arrays.asList("v10.stomp", "v11.stomp", "v12.stomp");
    private final ActiveMQServer server;
    private final StompProtocolManagerFactory factory;
    private final Executor executor;
    private final Map<Object, Map<Object, StompSession>> transactedSessions = new ConcurrentHashMap<Object, Map<Object, StompSession>>();
    private final Map<Object, StompSession> sessions = new HashMap<Object, StompSession>();
    private final List<StompFrameInterceptor> incomingInterceptors;
    private final List<StompFrameInterceptor> outgoingInterceptors;

    StompProtocolManager(StompProtocolManagerFactory factory, ActiveMQServer server, List<StompFrameInterceptor> incomingInterceptors, List<StompFrameInterceptor> outgoingInterceptors) {
        this.factory = factory;
        this.server = server;
        this.executor = server.getExecutorFactory().getExecutor();
        this.incomingInterceptors = incomingInterceptors;
        this.outgoingInterceptors = outgoingInterceptors;
    }

    public boolean acceptsNoHandshake() {
        return false;
    }

    public ProtocolManagerFactory<StompFrameInterceptor> getFactory() {
        return this.factory;
    }

    public void updateInterceptors(List<BaseInterceptor> incoming, List<BaseInterceptor> outgoing) {
        this.incomingInterceptors.clear();
        this.incomingInterceptors.addAll(this.getFactory().filterInterceptors(incoming));
        this.outgoingInterceptors.clear();
        this.outgoingInterceptors.addAll(this.getFactory().filterInterceptors(outgoing));
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        Long ttl;
        StompConnection conn = new StompConnection(acceptorUsed, connection, this, this.server.getScheduledPool(), this.server.getExecutorFactory());
        String ttlStr = (String)acceptorUsed.getConfiguration().get("connectionTtl");
        Long l = ttl = ttlStr == null ? null : Long.valueOf(ttlStr);
        if (ttl != null) {
            if (ttl > 0L) {
                return new ConnectionEntry((RemotingConnection)conn, null, System.currentTimeMillis(), ttl.longValue());
            }
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.negativeConnectionTTL(ttl);
        }
        ttl = this.server.getConfiguration().getConnectionTTLOverride();
        if (ttl != -1L) {
            return new ConnectionEntry((RemotingConnection)conn, null, System.currentTimeMillis(), ttl.longValue());
        }
        return new ConnectionEntry((RemotingConnection)conn, null, System.currentTimeMillis(), 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
        StompConnection conn = (StompConnection)connection;
        do {
            StompFrame request;
            try {
                request = conn.decode(buffer);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorDecodingPacket(e);
                return;
            }
            if (request == null) break;
            try {
                if (AuditLogger.isAnyLoggingEnabled()) {
                    AuditLogger.setRemoteAddress((String)connection.getRemoteAddress());
                }
                conn.logFrame(request, true);
                if (this.invokeInterceptors(this.incomingInterceptors, request, (RemotingConnection)conn) != null) {
                    return;
                }
                conn.handleFrame(request);
            }
            finally {
                this.server.getStorageManager().clearContext();
            }
        } while (conn.hasBytes());
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
    }

    public boolean isProtocol(byte[] array) {
        String frameStart = new String(array, StandardCharsets.US_ASCII);
        return frameStart.startsWith("CONNECT") || frameStart.startsWith("STOMP");
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }

    public List<String> websocketSubprotocolIdentifiers() {
        return websocketRegistryNames;
    }

    public RoutingHandler getRoutingHandler() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(StompConnection connection, StompFrame frame) {
        if (this.invokeInterceptors(this.outgoingInterceptors, frame, (RemotingConnection)connection) != null) {
            return false;
        }
        connection.logFrame(frame, false);
        StompConnection stompConnection = connection;
        synchronized (stompConnection) {
            if (connection.isDestroyed()) {
                ActiveMQStompProtocolLogger.LOGGER.connectionClosed(connection);
                return false;
            }
            try {
                connection.physicalSend(frame);
            }
            catch (Exception e) {
                ActiveMQStompProtocolLogger.LOGGER.errorSendingFrame(frame, e);
                return false;
            }
            return true;
        }
    }

    public StompSession getSession(StompConnection connection) throws Exception {
        return this.internalGetSession(connection, this.sessions, connection.getID(), false);
    }

    public StompSession getTransactedSession(StompConnection connection, String txID) throws Exception {
        return this.internalGetSession(connection, this.getTXMap(connection.getID()), txID, true);
    }

    public Map<Object, Map<Object, StompSession>> getTransactedSessions() {
        return this.transactedSessions;
    }

    private Map<Object, StompSession> getTXMap(Object objectID) {
        Map<Object, StompSession> oldValue;
        Map<Object, StompSession> sessions = this.transactedSessions.get(objectID);
        if (sessions == null && (oldValue = this.transactedSessions.putIfAbsent(objectID, sessions = new HashMap<Object, StompSession>())) != null) {
            sessions = oldValue;
        }
        return sessions;
    }

    private StompSession internalGetSession(StompConnection connection, Map<Object, StompSession> sessions, Object id, boolean transacted) throws Exception {
        StompSession stompSession = sessions.get(id);
        if (stompSession == null) {
            stompSession = new StompSession(connection, this, this.server.getStorageManager().newContext((Executor)connection.getTransportConnection().getEventLoop()));
            String name = UUIDGenerator.getInstance().generateStringUUID();
            String validatedUser = this.server.validateUser(connection.getLogin(), connection.getPasscode(), (RemotingConnection)connection, this.getSecurityDomain());
            ServerSession session = this.server.createSession(name, connection.getLogin(), connection.getPasscode(), 102400, (RemotingConnection)connection, !transacted, false, false, false, null, (SessionCallback)stompSession, true, this.server.newOperationContext(), this.getPrefixes(), this.getSecurityDomain(), validatedUser, false);
            stompSession.setServerSession(session);
            sessions.put(id, stompSession);
        }
        this.server.getStorageManager().setContext(stompSession.getContext());
        return stompSession;
    }

    public void cleanup(StompConnection connection) {
        connection.setValid(false);
        this.executor.execute(() -> {
            StompSession session = this.sessions.remove(connection.getID());
            if (session != null) {
                try {
                    session.getCoreSession().stop();
                    session.getCoreSession().rollback(true);
                    session.getCoreSession().close(false);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorCleaningStompConn(e);
                }
            }
            Map<Object, StompSession> sessionMap = this.getTXMap(connection.getID());
            sessionMap.values().forEach(ss -> {
                try {
                    ss.getCoreSession().rollback(false);
                    ss.getCoreSession().close(false);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorCleaningStompConn(e);
                }
            });
            sessionMap.clear();
            this.transactedSessions.remove(connection.getID());
        });
    }

    public void sendReply(final StompConnection connection, final StompFrame frame, final StompPostReceiptFunction function) {
        this.server.getStorageManager().afterCompleteOperations(new IOCallback(){
            final /* synthetic */ StompProtocolManager this$0;
            {
                this.this$0 = this$0;
            }

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.errorProcessingIOCallback(Integer.valueOf(errorCode), errorMessage);
                ActiveMQStompException e = new ActiveMQStompException("Error sending reply", (Throwable)ActiveMQExceptionType.createException((int)errorCode, (String)errorMessage)).setHandler(connection.getFrameHandler());
                StompFrame error = e.getFrame();
                this.this$0.send(connection, error);
            }

            public void done() {
                if (frame != null) {
                    this.this$0.send(connection, frame);
                }
                if (function != null) {
                    function.afterReceipt();
                }
            }
        });
    }

    public String getSupportedVersionsAsString() {
        Object versions = "";
        for (StompVersions version : StompVersions.values()) {
            versions = (String)versions + " v" + String.valueOf((Object)version);
        }
        return ((String)versions).substring(1);
    }

    public String getSupportedVersionsAsErrorVersion() {
        Object versions = "";
        for (StompVersions version : StompVersions.values()) {
            versions = (String)versions + "," + String.valueOf((Object)version);
        }
        return ((String)versions).substring(1);
    }

    public String getVirtualHostName() {
        return "activemq";
    }

    public CoreMessage createServerMessage() {
        return new CoreMessage(this.server.getStorageManager().generateID(), 512);
    }

    public void commitTransaction(StompConnection connection, String txID) throws Exception {
        StompSession session = this.getTransactedSession(connection, txID);
        if (session == null || !session.isTxPending()) {
            throw new ActiveMQStompException(connection, "No transaction started: " + txID);
        }
        session.getCoreSession().commit();
        session.end();
    }

    public void abortTransaction(StompConnection connection, String txID) throws Exception {
        StompSession session = this.getTransactedSession(connection, txID);
        if (session == null || !session.isTxPending()) {
            throw new ActiveMQStompException(connection, "No transaction started: " + txID);
        }
        session.getCoreSession().rollback(false);
        session.end();
    }

    public StompPostReceiptFunction subscribe(StompConnection connection, String subscriptionID, String durableSubscriptionName, String destination, String selector, String ack, boolean noLocal, Integer consumerWindowSize) throws Exception {
        StompSession stompSession = this.getSession(connection);
        if (stompSession.containsSubscription(subscriptionID)) {
            throw new ActiveMQStompException(connection, "There already is a subscription for: " + subscriptionID + ". Either use unique subscription IDs or do not create multiple subscriptions for the same destination");
        }
        long consumerID = this.server.getStorageManager().generateID();
        return stompSession.addSubscription(consumerID, subscriptionID, connection.getClientID(), durableSubscriptionName, destination, selector, ack, noLocal, consumerWindowSize);
    }

    public void unsubscribe(StompConnection connection, String subscriptionID, String durableSubscriberName) throws Exception {
        StompSession stompSession = this.getSession(connection);
        boolean unsubscribed = stompSession.unsubscribe(subscriptionID, durableSubscriberName, connection.getClientID());
        if (!unsubscribed) {
            throw new ActiveMQStompException(connection, "Cannot unsubscribe as no subscription exists for id: " + subscriptionID);
        }
    }

    public void acknowledge(StompConnection connection, String messageID, String subscriptionID) throws Exception {
        StompSession stompSession = this.getSession(connection);
        stompSession.acknowledge(messageID, subscriptionID);
    }

    public void beginTransaction(StompConnection connection, String txID) throws Exception {
        logger.debug("-------------------------------Stomp begin tx: {}", (Object)txID);
        StompSession session = this.getTransactedSession(connection, txID);
        if (session.isTxPending()) {
            ActiveMQServerLogger.LOGGER.stompErrorTXExists(txID);
            throw new ActiveMQStompException(connection, "Transaction already started: " + txID);
        }
        session.begin();
    }

    public boolean destinationExists(String destination) {
        if (this.server.getManagementService().getManagementAddress().toString().equals(destination)) {
            return true;
        }
        return this.server.getPostOffice().getAddressInfo(SimpleString.of((String)destination)) != null;
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public Collection<StompSession> getSessions() {
        return this.sessions.values();
    }
}

