/*
 * DelayHandler.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 2003-2004 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): suhler.
 *
 * Version:  1.3
 * Created by suhler on 03/08/28
 * Last modified by suhler on 04/05/24 15:24:09
 */

package sunlabs.brazil.sunlabs;

import java.io.IOException;
import sunlabs.brazil.server.Handler;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.server.Server;
import sunlabs.brazil.handler.MatchString;

import sunlabs.brazil.template.RewriteContext;
import sunlabs.brazil.template.Template;

/**
 * Handler or template for adding a delay into a response.
 * <p>
 * Properties:
 * <dl class=props>
 * <dt>prefix, suffix, match, glob<dd>Specify which url's to process.
 * <dt>delay<dd>The delay, in ms (defaults to 1000).
 * </dl>
 */

public class DelayHandler extends Template implements Handler {
    MatchString isMine;            // check for matching url
    int delay=1000;		   // delay in msec

    public boolean
    init(Server server, String prefix) {
	isMine = new MatchString(prefix, server.props);
	try {
	    String str = server.props.getProperty(prefix + "delay");
	    delay = Integer.decode(str).intValue();
	} catch (Exception e) {}
	return true;
    }

    /**
     * Delay before servicing this request.
     * <pre>&lt;delay ms=nnn&gt;</pre>
     */

    public boolean
    respond(Request request) throws IOException {
	if (isMine.match(request.url)) {
	    try {
		Thread.sleep(delay);
	    } catch (InterruptedException e) {}
        }
	return false;
    }

    /**
     * pause for "delay" ms
     */

    public void
    tag_delay(RewriteContext hr) {
	debug(hr);
	try {
	    String str = hr.get("delay", "0");
	    int delay = Integer.decode(str).intValue();
	    Thread.sleep(delay);
	} catch (Exception e) {}
    }
}
