/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast.management.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Group;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.core.command.Command;
import org.apache.karaf.cellar.core.command.ExecutionContext;
import org.apache.karaf.cellar.core.control.ConsumerSwitchCommand;
import org.apache.karaf.cellar.core.control.ConsumerSwitchResult;
import org.apache.karaf.cellar.core.control.ManageHandlersCommand;
import org.apache.karaf.cellar.core.control.ManageHandlersResult;
import org.apache.karaf.cellar.core.control.ProducerSwitchCommand;
import org.apache.karaf.cellar.core.control.ProducerSwitchResult;
import org.apache.karaf.cellar.core.control.ShutdownCommand;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.core.management.CellarMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class CellarMBeanImpl
extends StandardMBean
implements CellarMBean {
    private BundleContext bundleContext;
    private ClusterManager clusterManager;
    private ExecutionContext executionContext;
    private GroupManager groupManager;

    public CellarMBeanImpl() throws NotCompliantMBeanException {
        super(CellarMBean.class);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public void sync() throws Exception {
        Set localGroups = this.groupManager.listLocalGroups();
        for (Group group : localGroups) {
            try {
                ServiceReference[] serviceReferences = this.bundleContext.getAllServiceReferences("org.apache.karaf.cellar.core.Synchronizer", null);
                if (serviceReferences == null || serviceReferences.length <= 0) continue;
                for (ServiceReference ref : serviceReferences) {
                    Synchronizer synchronizer = (Synchronizer)this.bundleContext.getService(ref);
                    synchronizer.sync(group);
                    this.bundleContext.ungetService(ref);
                }
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
            }
        }
    }

    public TabularData handlerStatus() throws Exception {
        ManageHandlersCommand command = new ManageHandlersCommand(this.clusterManager.generateId());
        command.setDestination(this.clusterManager.listNodes());
        command.setHandlerName(null);
        command.setStatus(null);
        Map results = this.executionContext.execute((Command)command);
        CompositeType compositeType = new CompositeType("Event Handler", "Karaf Cellar cluster event handler", new String[]{"node", "handler", "status", "local"}, new String[]{"Node hosting event handler", "Name of the event handler", "Current status of the event handler", "True if the node is local"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.BOOLEAN});
        TabularType tableType = new TabularType("Event Handlers", "Table of Karaf Cellar cluster event handlers", compositeType, new String[]{"node", "handler"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        for (Map.Entry handlersResultEntry : results.entrySet()) {
            Node node = (Node)handlersResultEntry.getKey();
            ManageHandlersResult result = (ManageHandlersResult)handlersResultEntry.getValue();
            if (result == null || result.getHandlers() == null) continue;
            for (Map.Entry handlerEntry : result.getHandlers().entrySet()) {
                String handler = (String)handlerEntry.getKey();
                String status = (String)handlerEntry.getValue();
                String nodeName = node.getAlias();
                if (nodeName == null) {
                    nodeName = node.getId();
                }
                boolean local = node.equals(this.clusterManager.getNode());
                CompositeDataSupport data = new CompositeDataSupport(compositeType, new String[]{"node", "handler", "status", "local"}, new Object[]{nodeName, handler, status, local});
                table.put(data);
            }
        }
        return table;
    }

    public void handlerStart(String handlerId, String nodeIdOrAlias) throws Exception {
        ManageHandlersCommand command = new ManageHandlersCommand(this.clusterManager.generateId());
        HashSet<Node> nodes = new HashSet<Node>();
        if (nodeIdOrAlias == null || nodeIdOrAlias.isEmpty()) {
            nodes.add(this.clusterManager.getNode());
        } else {
            Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
            if (node == null) {
                throw new IllegalArgumentException("Cluster node " + nodeIdOrAlias + " doesn't exist");
            }
            nodes.add(node);
        }
        command.setHandlerName(handlerId);
        command.setDestination(nodes);
        command.setStatus(Boolean.TRUE);
    }

    public void handlerStop(String handlerId, String nodeIdOrAlias) throws Exception {
        ManageHandlersCommand command = new ManageHandlersCommand(this.clusterManager.generateId());
        HashSet<Node> nodes = new HashSet<Node>();
        if (nodeIdOrAlias == null || nodeIdOrAlias.isEmpty()) {
            nodes.add(this.clusterManager.getNode());
        } else {
            Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
            if (node == null) {
                throw new IllegalArgumentException("Cluster node " + nodeIdOrAlias + " doesn't exist");
            }
            nodes.add(node);
        }
        command.setHandlerName(handlerId);
        command.setDestination(nodes);
        command.setStatus(Boolean.FALSE);
    }

    public TabularData consumerStatus() throws Exception {
        ConsumerSwitchCommand command = new ConsumerSwitchCommand(this.clusterManager.generateId());
        command.setStatus(null);
        Map results = this.executionContext.execute((Command)command);
        CompositeType compositeType = new CompositeType("Event Consumer", "Karaf Cellar cluster event consumer", new String[]{"node", "status", "local"}, new String[]{"Node hosting event consumer", "Current status of the event consumer", "True if the node is local"}, new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN});
        TabularType tableType = new TabularType("Event Consumers", "Table of Karaf Cellar cluster event consumers", compositeType, new String[]{"node"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        for (Node node : results.keySet()) {
            boolean local = node.equals(this.clusterManager.getNode());
            ConsumerSwitchResult consumerSwitchResult = (ConsumerSwitchResult)results.get(node);
            String nodeName = node.getAlias();
            if (nodeName == null) {
                nodeName = node.getId();
            }
            CompositeDataSupport data = new CompositeDataSupport(compositeType, new String[]{"node", "status", "local"}, new Object[]{nodeName, consumerSwitchResult.getStatus(), local});
            table.put(data);
        }
        return table;
    }

    public void consumerStart(String nodeIdOrAlias) throws Exception {
        ConsumerSwitchCommand command = new ConsumerSwitchCommand(this.clusterManager.generateId());
        HashSet<Node> nodes = new HashSet<Node>();
        if (nodeIdOrAlias == null || nodeIdOrAlias.isEmpty()) {
            nodes.add(this.clusterManager.getNode());
        } else {
            Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
            if (node == null) {
                throw new IllegalArgumentException("Cluster node " + nodeIdOrAlias + " doesn't exist");
            }
            nodes.add(node);
        }
        command.setDestination(nodes);
        command.setStatus(SwitchStatus.ON);
        this.executionContext.execute((Command)command);
    }

    public void consumerStop(String nodeIdOrAlias) throws Exception {
        ConsumerSwitchCommand command = new ConsumerSwitchCommand(this.clusterManager.generateId());
        HashSet<Node> nodes = new HashSet<Node>();
        if (nodeIdOrAlias == null || nodeIdOrAlias.isEmpty()) {
            nodes.add(this.clusterManager.getNode());
        } else {
            Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
            if (node == null) {
                throw new IllegalArgumentException("Cluster node " + nodeIdOrAlias + " doesn't exist");
            }
            nodes.add(node);
        }
        command.setDestination(nodes);
        command.setStatus(SwitchStatus.OFF);
        this.executionContext.execute((Command)command);
    }

    public TabularData producerStatus() throws Exception {
        ProducerSwitchCommand command = new ProducerSwitchCommand(this.clusterManager.generateId());
        command.setStatus(null);
        Map results = this.executionContext.execute((Command)command);
        CompositeType compositeType = new CompositeType("Event Producer", "Karaf Cellar cluster event producer", new String[]{"node", "status", "local"}, new String[]{"Node hosting event producer", "Current status of the event producer", "True if the node is local"}, new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN});
        TabularType tableType = new TabularType("Event Producers", "Table of Karaf Cellar cluster event producers", compositeType, new String[]{"node"});
        TabularDataSupport table = new TabularDataSupport(tableType);
        for (Node node : results.keySet()) {
            boolean local = node.equals(this.clusterManager.getNode());
            ProducerSwitchResult producerSwitchResult = (ProducerSwitchResult)results.get(node);
            String nodeName = node.getAlias();
            if (nodeName == null) {
                nodeName = node.getId();
            }
            CompositeDataSupport data = new CompositeDataSupport(compositeType, new String[]{"node", "status", "local"}, new Object[]{nodeName, producerSwitchResult.getStatus(), local});
            table.put(data);
        }
        return table;
    }

    public void producerStop(String nodeIdOrAlias) throws Exception {
        ProducerSwitchCommand command = new ProducerSwitchCommand(this.clusterManager.generateId());
        HashSet<Node> nodes = new HashSet<Node>();
        if (nodeIdOrAlias == null || nodeIdOrAlias.isEmpty()) {
            nodes.add(this.clusterManager.getNode());
        } else {
            Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
            if (node == null) {
                throw new IllegalArgumentException("Cluster node " + nodeIdOrAlias + " doesn't exist");
            }
            nodes.add(node);
        }
        command.setDestination(nodes);
        command.setStatus(SwitchStatus.OFF);
        this.executionContext.execute((Command)command);
    }

    public void producerStart(String nodeIdOrAlias) throws Exception {
        ProducerSwitchCommand command = new ProducerSwitchCommand(this.clusterManager.generateId());
        HashSet<Node> nodes = new HashSet<Node>();
        if (nodeIdOrAlias == null || nodeIdOrAlias.isEmpty()) {
            nodes.add(this.clusterManager.getNode());
        } else {
            Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
            if (node == null) {
                throw new IllegalArgumentException("Cluster node " + nodeIdOrAlias + " doesn't exist)");
            }
            nodes.add(node);
        }
        command.setDestination(nodes);
        command.setStatus(SwitchStatus.ON);
        this.executionContext.execute((Command)command);
    }

    public void shutdown() throws Exception {
        this.shutdown(false);
    }

    public void shutdown(boolean poweroff) throws Exception {
        ShutdownCommand command = new ShutdownCommand(this.clusterManager.generateId());
        Set nodes = this.clusterManager.listNodes();
        command.setDestination(nodes);
        command.setHalt(poweroff);
        this.executionContext.execute((Command)command);
    }
}

