/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast.internal.osgi;

import com.hazelcast.core.HazelcastInstance;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.aries.proxy.ProxyManager;
import org.apache.karaf.cellar.core.ClusterManager;
import org.apache.karaf.cellar.core.Consumer;
import org.apache.karaf.cellar.core.Dispatcher;
import org.apache.karaf.cellar.core.GroupManager;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.Producer;
import org.apache.karaf.cellar.core.Synchronizer;
import org.apache.karaf.cellar.core.command.BasicCommandStore;
import org.apache.karaf.cellar.core.command.ClusteredExecutionContext;
import org.apache.karaf.cellar.core.command.CommandStore;
import org.apache.karaf.cellar.core.command.ExecutionContext;
import org.apache.karaf.cellar.core.control.ConsumerSwitchCommandHandler;
import org.apache.karaf.cellar.core.control.ConsumerSwitchResultHandler;
import org.apache.karaf.cellar.core.control.ManageGroupCommandHandler;
import org.apache.karaf.cellar.core.control.ManageGroupResultHandler;
import org.apache.karaf.cellar.core.control.ManageHandlersCommandHandler;
import org.apache.karaf.cellar.core.control.ManageHandlersResultHandler;
import org.apache.karaf.cellar.core.control.ProducerSwitchCommandHandler;
import org.apache.karaf.cellar.core.control.ProducerSwitchResultHandler;
import org.apache.karaf.cellar.core.control.ShutdownCommandHandler;
import org.apache.karaf.cellar.core.control.ShutdownResultHandler;
import org.apache.karaf.cellar.core.discovery.DiscoveryService;
import org.apache.karaf.cellar.core.discovery.DiscoveryTask;
import org.apache.karaf.cellar.core.event.EventHandler;
import org.apache.karaf.cellar.core.event.EventHandlerRegistry;
import org.apache.karaf.cellar.core.event.EventHandlerRegistryDispatcher;
import org.apache.karaf.cellar.core.event.EventProducer;
import org.apache.karaf.cellar.core.event.EventTransportFactory;
import org.apache.karaf.cellar.core.management.CellarGroupMBean;
import org.apache.karaf.cellar.core.management.CellarMBean;
import org.apache.karaf.cellar.core.management.CellarNodeMBean;
import org.apache.karaf.cellar.core.utils.CombinedClassLoader;
import org.apache.karaf.cellar.hazelcast.CellarExtender;
import org.apache.karaf.cellar.hazelcast.CellarMembershipListener;
import org.apache.karaf.cellar.hazelcast.HazelcastClusterManager;
import org.apache.karaf.cellar.hazelcast.HazelcastEventTransportFactory;
import org.apache.karaf.cellar.hazelcast.HazelcastGroupManager;
import org.apache.karaf.cellar.hazelcast.TopicConsumer;
import org.apache.karaf.cellar.hazelcast.TopicProducer;
import org.apache.karaf.cellar.hazelcast.factory.HazelcastConfigurationManager;
import org.apache.karaf.cellar.hazelcast.factory.HazelcastServiceFactory;
import org.apache.karaf.cellar.hazelcast.management.internal.CellarGroupMBeanImpl;
import org.apache.karaf.cellar.hazelcast.management.internal.CellarMBeanImpl;
import org.apache.karaf.cellar.hazelcast.management.internal.CellarNodeMBeanImpl;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.SynchronousConfigurationListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Services(provides={@ProvideService(value=HazelcastInstance.class), @ProvideService(value=ClusterManager.class), @ProvideService(value=GroupManager.class), @ProvideService(value=EventTransportFactory.class), @ProvideService(value=EventProducer.class), @ProvideService(value=ExecutionContext.class), @ProvideService(value=EventHandler.class), @ProvideService(value=CommandStore.class), @ProvideService(value=CellarMBean.class), @ProvideService(value=CellarNodeMBean.class), @ProvideService(value=CellarGroupMBean.class)}, requires={@RequireService(value=ConfigurationAdmin.class), @RequireService(value=ProxyManager.class), @RequireService(value=EventHandlerRegistry.class)})
@Managed(value="org.apache.karaf.cellar.discovery")
public class Activator
extends BaseActivator
implements ManagedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(Activator.class);
    private CombinedClassLoader combinedClassLoader;
    private HazelcastServiceFactory hazelcastServiceFactory;
    private List<DiscoveryService> discoveryServices = new ArrayList<DiscoveryService>();
    private List<Synchronizer> synchronizers = new ArrayList<Synchronizer>();
    private HazelcastInstance hazelcastInstance;
    private HazelcastGroupManager groupManager;
    private DiscoveryTask discoveryTask;
    private CellarExtender extender;
    private TopicProducer producer;
    private TopicConsumer consumer;
    private ServiceTracker<DiscoveryService, DiscoveryService> discoveryServiceTracker;
    private ServiceTracker<Synchronizer, Synchronizer> synchronizerServiceTracker;
    private volatile ServiceRegistration coreMBeanRegistration;
    private volatile ServiceRegistration nodeMBeanRegistration;
    private volatile ServiceRegistration groupMBeanRegistration;
    private HashMap updatedConfig;
    private EventHandlerRegistryDispatcher dispatcher;

    @Override
    public void doStart() throws Exception {
        ConfigurationAdmin configurationAdmin = this.getTrackedService(ConfigurationAdmin.class);
        if (configurationAdmin == null) {
            return;
        }
        EventHandlerRegistry eventHandlerRegistry = this.getTrackedService(EventHandlerRegistry.class);
        if (eventHandlerRegistry == null) {
            return;
        }
        ProxyManager proxyManager = this.getTrackedService(ProxyManager.class);
        if (proxyManager == null) {
            return;
        }
        LOGGER.debug("CELLAR HAZELCAST: init combined class loader");
        this.combinedClassLoader = new CombinedClassLoader();
        this.combinedClassLoader.init();
        LOGGER.debug("CELLAR HAZELCAST: start the discovery service tracker");
        this.discoveryServiceTracker = new ServiceTracker(this.bundleContext, DiscoveryService.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<DiscoveryService, DiscoveryService>(){

            public DiscoveryService addingService(ServiceReference<DiscoveryService> serviceReference) {
                DiscoveryService service = (DiscoveryService)Activator.this.bundleContext.getService(serviceReference);
                Activator.this.discoveryServices.add(service);
                return service;
            }

            public void modifiedService(ServiceReference<DiscoveryService> serviceReference, DiscoveryService discoveryService) {
            }

            public void removedService(ServiceReference<DiscoveryService> serviceReference, DiscoveryService discoveryService) {
                Activator.this.discoveryServices.remove(discoveryService);
                Activator.this.bundleContext.ungetService(serviceReference);
            }
        });
        this.discoveryServiceTracker.open();
        LOGGER.debug("CELLAR HAZELCAST:\u00a0init Cellar extender");
        this.extender = new CellarExtender();
        this.extender.setCombinedClassLoader(this.combinedClassLoader);
        this.extender.setBundleContext(this.bundleContext);
        this.extender.init();
        LOGGER.debug("CELLAR HAZELCAST:\u00a0init dispatcher");
        this.dispatcher = new EventHandlerRegistryDispatcher();
        this.dispatcher.setHandlerRegistry(eventHandlerRegistry);
        this.dispatcher.init();
        LOGGER.debug("CELLAR HAZELCAST: create Hazelcast configuration manager");
        HazelcastConfigurationManager hazelcastConfigurationManager = new HazelcastConfigurationManager();
        hazelcastConfigurationManager.setDiscoveryServices(this.discoveryServices);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0init Hazelcast service factory");
        this.hazelcastServiceFactory = new HazelcastServiceFactory();
        this.hazelcastServiceFactory.setCombinedClassLoader(this.combinedClassLoader);
        this.hazelcastServiceFactory.setConfigurationManager(hazelcastConfigurationManager);
        this.hazelcastServiceFactory.setBundleContext(this.bundleContext);
        this.hazelcastServiceFactory.init();
        if (this.updatedConfig != null) {
            this.updated(this.updatedConfig);
            this.updatedConfig = null;
        }
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register Hazelcast instance");
        this.hazelcastInstance = this.hazelcastServiceFactory.getInstance();
        this.register(HazelcastInstance.class, this.hazelcastInstance);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0init discovery task");
        this.discoveryTask = new DiscoveryTask();
        this.discoveryTask.setDiscoveryServices(this.discoveryServices);
        this.discoveryTask.setConfigurationAdmin(configurationAdmin);
        this.discoveryTask.init();
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register Hazelcast cluster manager");
        HazelcastClusterManager clusterManager = new HazelcastClusterManager();
        clusterManager.setInstance(this.hazelcastInstance);
        clusterManager.setConfigurationAdmin(configurationAdmin);
        clusterManager.setCombinedClassLoader(this.combinedClassLoader);
        this.register(ClusterManager.class, clusterManager);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0create Hazelcast event transport factory");
        HazelcastEventTransportFactory eventTransportFactory = new HazelcastEventTransportFactory();
        eventTransportFactory.setCombinedClassLoader(this.combinedClassLoader);
        eventTransportFactory.setConfigurationAdmin(configurationAdmin);
        eventTransportFactory.setInstance(this.hazelcastInstance);
        eventTransportFactory.setDispatcher((Dispatcher)this.dispatcher);
        this.register(EventTransportFactory.class, eventTransportFactory);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0init Hazelcast group manager");
        this.groupManager = new HazelcastGroupManager();
        this.groupManager.setInstance(this.hazelcastInstance);
        this.groupManager.setCombinedClassLoader(this.combinedClassLoader);
        this.groupManager.setBundleContext(this.bundleContext);
        this.groupManager.setConfigurationAdmin(configurationAdmin);
        this.groupManager.setEventTransportFactory(eventTransportFactory);
        this.groupManager.init();
        this.register(new Class[]{GroupManager.class, SynchronousConfigurationListener.class}, this.groupManager);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0create Cellar membership listener");
        CellarMembershipListener membershipListener = new CellarMembershipListener(this.hazelcastInstance);
        membershipListener.setSynchronizers(this.synchronizers);
        membershipListener.setGroupManager(this.groupManager);
        Node node = clusterManager.getNode();
        LOGGER.debug("CELLAR HAZELCAST:\u00a0init topic consumer");
        this.consumer = new TopicConsumer();
        this.consumer.setInstance(this.hazelcastInstance);
        this.consumer.setDispatcher((Dispatcher)this.dispatcher);
        this.consumer.setNode(node);
        this.consumer.setConfigurationAdmin(configurationAdmin);
        this.consumer.init();
        LOGGER.debug("CELLAR HAZELCAST:\u00a0init topic producer");
        this.producer = new TopicProducer();
        this.producer.setInstance(this.hazelcastInstance);
        this.producer.setNode(node);
        this.producer.setConfigurationAdmin(configurationAdmin);
        this.producer.init();
        this.register(EventProducer.class, this.producer);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register basic command store");
        BasicCommandStore commandStore = new BasicCommandStore();
        this.register(CommandStore.class, commandStore);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register clustered execution context");
        ClusteredExecutionContext executionContext = new ClusteredExecutionContext();
        executionContext.setProducer((Producer)this.producer);
        executionContext.setCommandStore((CommandStore)commandStore);
        this.register(ExecutionContext.class, executionContext);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register producer switch command handler");
        ProducerSwitchCommandHandler producerSwitchCommandHandler = new ProducerSwitchCommandHandler();
        producerSwitchCommandHandler.setProducer((Producer)this.producer);
        producerSwitchCommandHandler.setConfigurationAdmin(configurationAdmin);
        this.register(EventHandler.class, producerSwitchCommandHandler);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register producer switch result handler");
        ProducerSwitchResultHandler producerSwitchResultHandler = new ProducerSwitchResultHandler();
        producerSwitchResultHandler.setCommandStore((CommandStore)commandStore);
        this.register(EventHandler.class, producerSwitchResultHandler);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register consumer switch command handler");
        ConsumerSwitchCommandHandler consumerSwitchCommandHandler = new ConsumerSwitchCommandHandler();
        consumerSwitchCommandHandler.setProducer((Producer)this.producer);
        consumerSwitchCommandHandler.setConsumer((Consumer)this.consumer);
        consumerSwitchCommandHandler.setConfigurationAdmin(configurationAdmin);
        this.register(EventHandler.class, consumerSwitchCommandHandler);
        LOGGER.debug("CELLAR HAZELCAST;\u00a0register consumer switch result handler");
        ConsumerSwitchResultHandler consumerSwitchResultHandler = new ConsumerSwitchResultHandler();
        consumerSwitchResultHandler.setCommandStore((CommandStore)commandStore);
        this.register(EventHandler.class, consumerSwitchResultHandler);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register manage handlers command handler");
        ManageHandlersCommandHandler manageHandlersCommandHandler = new ManageHandlersCommandHandler();
        manageHandlersCommandHandler.setConfigurationAdmin(configurationAdmin);
        manageHandlersCommandHandler.setProducer((Producer)this.producer);
        manageHandlersCommandHandler.setProxyManager(proxyManager);
        this.register(EventHandler.class, manageHandlersCommandHandler);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register manage handlers result handler");
        ManageHandlersResultHandler manageHandlersResultHandler = new ManageHandlersResultHandler();
        manageHandlersResultHandler.setCommandStore((CommandStore)commandStore);
        this.register(EventHandler.class, manageHandlersResultHandler);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register manage group command handler");
        ManageGroupCommandHandler manageGroupCommandHandler = new ManageGroupCommandHandler();
        manageGroupCommandHandler.setProducer((Producer)this.producer);
        manageGroupCommandHandler.setClusterManager((ClusterManager)clusterManager);
        manageGroupCommandHandler.setGroupManager((GroupManager)this.groupManager);
        this.register(EventHandler.class, manageGroupCommandHandler);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register manage group result handler");
        ManageGroupResultHandler manageGroupResultHandler = new ManageGroupResultHandler();
        manageGroupResultHandler.setCommandStore((CommandStore)commandStore);
        this.register(EventHandler.class, manageGroupResultHandler);
        LOGGER.debug("CELLAR HAZELCAST: register shutdown command handler");
        ShutdownCommandHandler shutdownCommandHandler = new ShutdownCommandHandler();
        shutdownCommandHandler.setBundleContext(this.bundleContext);
        shutdownCommandHandler.setProducer((Producer)this.producer);
        shutdownCommandHandler.setClusterManager((ClusterManager)clusterManager);
        shutdownCommandHandler.setGroupManager((GroupManager)this.groupManager);
        this.register(EventHandler.class, shutdownCommandHandler);
        LOGGER.debug("CELLAR HAZELCAST: register shutdown command result handler");
        ShutdownResultHandler shutdownResultHandler = new ShutdownResultHandler();
        shutdownResultHandler.setCommandStore((CommandStore)commandStore);
        this.register(EventHandler.class, shutdownCommandHandler);
        LOGGER.debug("CELLAR HAZELCAST: start the synchronizer service tracker");
        this.synchronizerServiceTracker = new ServiceTracker(this.bundleContext, Synchronizer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Synchronizer, Synchronizer>(){

            public Synchronizer addingService(ServiceReference<Synchronizer> serviceReference) {
                Synchronizer service = (Synchronizer)Activator.this.bundleContext.getService(serviceReference);
                Activator.this.synchronizers.add(service);
                return service;
            }

            public void modifiedService(ServiceReference<Synchronizer> serviceReference, Synchronizer synchronizer) {
            }

            public void removedService(ServiceReference<Synchronizer> serviceReference, Synchronizer synchronizer) {
                Activator.this.synchronizers.remove(synchronizer);
                Activator.this.bundleContext.ungetService(serviceReference);
            }
        });
        this.synchronizerServiceTracker.open();
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register Cellar Core MBean");
        CellarMBeanImpl cellarMBean = new CellarMBeanImpl();
        cellarMBean.setBundleContext(this.bundleContext);
        cellarMBean.setClusterManager(clusterManager);
        cellarMBean.setGroupManager(this.groupManager);
        cellarMBean.setExecutionContext((ExecutionContext)executionContext);
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("jmx.objectname", "org.apache.karaf.cellar:type=core,name=" + System.getProperty("karaf.name"));
        this.coreMBeanRegistration = this.bundleContext.registerService(this.getInterfaceNames(cellarMBean), (Object)cellarMBean, props);
        LOGGER.debug("CELLAR HAZELCAST:\u00a0register Cellar Node MBean");
        CellarNodeMBeanImpl cellarNodeMBean = new CellarNodeMBeanImpl();
        cellarNodeMBean.setClusterManager(clusterManager);
        cellarNodeMBean.setExecutionContext((ExecutionContext)executionContext);
        props = new Hashtable();
        props.put("jmx.objectname", "org.apache.karaf.cellar:type=node,name=" + System.getProperty("karaf.name"));
        this.nodeMBeanRegistration = this.bundleContext.registerService(this.getInterfaceNames(cellarNodeMBean), (Object)cellarNodeMBean, props);
        LOGGER.debug("CELLAR HAZELCAST: register Cellar Group MBean");
        CellarGroupMBeanImpl cellarGroupMBean = new CellarGroupMBeanImpl();
        cellarGroupMBean.setClusterManager(clusterManager);
        cellarGroupMBean.setExecutionContext((ExecutionContext)executionContext);
        cellarGroupMBean.setGroupManager(this.groupManager);
        props = new Hashtable();
        props.put("jmx.objectname", "org.apache.karaf.cellar:type=group,name=" + System.getProperty("karaf.name"));
        this.groupMBeanRegistration = this.bundleContext.registerService(this.getInterfaceNames(cellarGroupMBean), (Object)cellarGroupMBean, props);
    }

    @Override
    public void doStop() {
        super.doStop();
        if (this.groupMBeanRegistration != null) {
            this.groupMBeanRegistration.unregister();
            this.groupMBeanRegistration = null;
        }
        if (this.nodeMBeanRegistration != null) {
            this.nodeMBeanRegistration.unregister();
            this.nodeMBeanRegistration = null;
        }
        if (this.coreMBeanRegistration != null) {
            this.coreMBeanRegistration.unregister();
            this.coreMBeanRegistration = null;
        }
        if (this.synchronizerServiceTracker != null) {
            this.synchronizerServiceTracker.close();
            this.synchronizerServiceTracker = null;
        }
        if (this.groupManager != null) {
            try {
                this.groupManager.destroy();
            }
            catch (Exception e) {
                LOGGER.trace("Error occured destroying the group manager", (Throwable)e);
            }
            this.groupManager = null;
        }
        if (this.hazelcastServiceFactory != null) {
            this.hazelcastServiceFactory.destroy();
            this.hazelcastServiceFactory = null;
        }
        if (this.hazelcastInstance != null) {
            this.hazelcastInstance.shutdown();
            this.hazelcastInstance = null;
        }
        if (this.discoveryTask != null) {
            this.discoveryTask.destroy();
            this.discoveryTask = null;
        }
        if (this.producer != null) {
            this.producer.destroy();
            this.producer = null;
        }
        if (this.consumer != null) {
            this.consumer.destroy();
            this.consumer = null;
        }
        if (this.extender != null) {
            this.extender.destroy();
            this.extender = null;
        }
        if (this.discoveryServiceTracker != null) {
            this.discoveryServiceTracker.close();
            this.discoveryServiceTracker = null;
        }
        if (this.combinedClassLoader != null) {
            this.combinedClassLoader.destroy();
            this.combinedClassLoader = null;
        }
        if (this.dispatcher != null) {
            this.dispatcher.destroy();
            this.dispatcher = null;
        }
    }

    public void updated(Dictionary config) {
        if (config == null) {
            return;
        }
        HashMap map = new HashMap();
        Enumeration keys = config.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            map.put(key, config.get(key));
        }
        if (this.hazelcastServiceFactory != null) {
            this.updated(map);
        } else {
            this.updatedConfig = map;
        }
    }

    private void updated(HashMap config) {
        try {
            this.hazelcastServiceFactory.update(config);
        }
        catch (Exception e) {
            LOGGER.error("Can't update Hazelcast service factory", (Throwable)e);
        }
    }
}

