/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.router.services;

import org.apache.unomi.persistence.spi.PersistenceService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractCustomServiceImpl
implements SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCustomServiceImpl.class);
    protected PersistenceService persistenceService;
    protected BundleContext bundleContext;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void postConstruct() {
        logger.debug("postConstruct {" + this.bundleContext.getBundle() + "}");
        this.processBundleStartup(this.bundleContext);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null || bundle.getBundleId() == this.bundleContext.getBundle().getBundleId()) continue;
            this.processBundleStartup(bundle.getBundleContext());
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        logger.info("Import configuration service initialized.");
    }

    public void preDestroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        logger.info("Import configuration service shutdown.");
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
    }

    private void processBundleStop(BundleContext bundleContext) {
    }

    public void bundleChanged(BundleEvent bundleEvent) {
    }
}

